/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.jdeparser.AbstractJGeneric;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.AnnotationJClassDef;
import org.jboss.jdeparser.BlankLine;
import org.jboss.jdeparser.BlockJComment;
import org.jboss.jdeparser.ClassContent;
import org.jboss.jdeparser.ClassFileContent;
import org.jboss.jdeparser.ConstructorJMethodDef;
import org.jboss.jdeparser.EnumJClassDef;
import org.jboss.jdeparser.FirstJVarDeclaration;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJSourceFile;
import org.jboss.jdeparser.InitJBlock;
import org.jboss.jdeparser.InterfaceJClassDef;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JClassDefSection;
import org.jboss.jdeparser.JClassDefSectionImpl;
import org.jboss.jdeparser.JComment;
import org.jboss.jdeparser.JEnumConstant;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JMod;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypeParamDef;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.jdeparser.LineJComment;
import org.jboss.jdeparser.MethodJMethodDef;
import org.jboss.jdeparser.PlainJClassDef;
import org.jboss.jdeparser.Sectionable;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticInitJBlock;
import org.jboss.jdeparser.Tokens$;

abstract class AbstractJClassDef
extends AbstractJGeneric
implements JClassDef,
ClassFileContent,
ClassContent,
Sectionable {
    private final int mods;
    private final String name;
    private final AbstractJClassDef enclosingClass;
    private final ImplJSourceFile classFile;
    private final ArrayList<ClassContent> content = new ArrayList();
    private JType _extends;
    private ArrayList<JType> _implements;
    private JType erased;
    private JType generic;

    AbstractJClassDef(int mods, String name) {
        this.mods = mods;
        this.name = name;
        this.enclosingClass = null;
        this.classFile = null;
    }

    AbstractJClassDef(int mods, AbstractJClassDef enclosingClass, String name) {
        this.mods = mods;
        this.name = name;
        this.enclosingClass = enclosingClass;
        this.classFile = enclosingClass.classFile;
    }

    AbstractJClassDef(int mods, ImplJSourceFile classFile, String name) {
        this.mods = mods;
        this.name = name;
        this.enclosingClass = null;
        this.classFile = classFile;
    }

    AbstractJClassDef getEnclosingClass() {
        return this.enclosingClass;
    }

    ImplJSourceFile getClassFile() {
        return this.classFile;
    }

    int getMods() {
        return this.mods;
    }

    String getName() {
        return this.name;
    }

    <C extends ClassContent> C add(C item) {
        return this.add(this.content, item);
    }

    <C extends ClassContent> C add(ArrayList<ClassContent> content, C item) {
        content.add(item);
        return item;
    }

    @Override
    public JComment lineComment() {
        return this.add(new LineJComment());
    }

    @Override
    public JComment blockComment() {
        return this.add(new BlockJComment());
    }

    @Override
    public JClassDefSection section() {
        return this.add(new JClassDefSectionImpl(this));
    }

    @Override
    public JClassDef _extends(String name) {
        return this._extends(JTypes.typeNamed(name));
    }

    @Override
    public JClassDef _extends(JType type) {
        this._extends = type;
        return this;
    }

    @Override
    public JClassDef _extends(Class<?> clazz) {
        return this._extends(JTypes.typeOf(clazz));
    }

    @Override
    public JClassDef _implements(String ... names) {
        if (this._implements == null) {
            this._implements = new ArrayList(names.length);
        }
        for (String name : names) {
            this._implements.add(JTypes.typeNamed(name));
        }
        return this;
    }

    @Override
    public JClassDef _implements(JType ... types) {
        if (this._implements == null) {
            this._implements = new ArrayList(types.length);
        }
        Collections.addAll(this._implements, types);
        return this;
    }

    @Override
    public JClassDef _implements(Class<?> ... classes) {
        if (this._implements == null) {
            this._implements = new ArrayList(classes.length);
        }
        for (Class<?> clazz : classes) {
            this._implements.add(JTypes.typeOf(clazz));
        }
        return this;
    }

    @Override
    public JClassDef blankLine() {
        this.add(BlankLine.getInstance());
        return this;
    }

    @Override
    public JType erasedType() {
        if (this.erased == null) {
            this.erased = JTypes.typeNamed(this.name);
        }
        return this.erased;
    }

    @Override
    public JType genericType() {
        if (this.generic == null) {
            this.generic = this.erasedType().typeArg(this.typeParamsToArgs());
        }
        return this.generic;
    }

    @Override
    public JTypeParamDef typeParam(String name) {
        this.generic = null;
        return super.typeParam(name);
    }

    @Override
    public final JBlock init() {
        return this.init(this.content);
    }

    @Override
    public JBlock init(ArrayList<ClassContent> content) {
        return this.add(content, new InitJBlock());
    }

    @Override
    public final JBlock staticInit() {
        return this.staticInit(this.content);
    }

    @Override
    public JBlock staticInit(ArrayList<ClassContent> content) {
        if (JMod.allAreSet(this.mods, 0x40000000)) {
            throw new UnsupportedOperationException("Inner classes cannot have static init blocks");
        }
        return this.add(content, new StaticInitJBlock());
    }

    @Override
    public JEnumConstant _enum(String name) {
        throw new UnsupportedOperationException("Enum constants may only be added to enums");
    }

    @Override
    public JVarDeclaration field(ArrayList<ClassContent> content, int mods, JType type, String name, JExpr init) {
        if (JMod.allAreSet(this.mods, 0x40000000) && JMod.allAreSet(mods, 64)) {
            throw new UnsupportedOperationException("Inner classes cannot have static members");
        }
        if (JMod.anyAreSet(mods, -3967)) {
            throw new IllegalArgumentException("Invalid field modifier(s) given");
        }
        if (Integer.bitCount(mods & 0x38) > 1) {
            throw new IllegalArgumentException("Only one of 'public', 'protected', or 'private' may be given");
        }
        return this.add(content, new FirstJVarDeclaration(mods, type, name, init));
    }

    @Override
    public final JVarDeclaration field(int mods, JType type, String name) {
        return this.field(mods, type, name, null);
    }

    @Override
    public final JVarDeclaration field(int mods, JType type, String name, JExpr init) {
        return this.field(this.content, mods, type, name, init);
    }

    @Override
    public final JVarDeclaration field(int mods, Class<?> type, String name) {
        return this.field(mods, JTypes.typeOf(type), name);
    }

    @Override
    public final JVarDeclaration field(int mods, Class<?> type, String name, JExpr init) {
        return this.field(mods, JTypes.typeOf(type), name, init);
    }

    @Override
    public final JVarDeclaration field(int mods, String type, String name) {
        return this.field(mods, JTypes.typeNamed(type), name);
    }

    @Override
    public final JVarDeclaration field(int mods, String type, String name, JExpr init) {
        return this.field(mods, JTypes.typeNamed(type), name, init);
    }

    @Override
    public JMethodDef method(ArrayList<ClassContent> content, int mods, JType returnType, String name) {
        if (JMod.allAreSet(this.mods, 0x40000000) && JMod.allAreSet(mods, 64)) {
            throw new UnsupportedOperationException("Inner classes cannot have static members");
        }
        if (Integer.bitCount(mods & 3) > 1) {
            throw new IllegalArgumentException("Only one of 'abstract' or 'final' may be given");
        }
        if (Integer.bitCount(mods & 0x38) > 1) {
            throw new IllegalArgumentException("Only one of 'public', 'protected', or 'private' may be given");
        }
        if (JMod.anyAreSet(mods, -2560)) {
            throw new IllegalArgumentException("Invalid method modifier(s) given");
        }
        return this.add(content, new MethodJMethodDef(this, mods, returnType, name));
    }

    @Override
    public final JMethodDef method(int mods, JType returnType, String name) {
        return this.method(this.content, mods, returnType, name);
    }

    @Override
    public final JMethodDef method(int mods, Class<?> returnType, String name) {
        return this.method(mods, JTypes.typeOf(returnType), name);
    }

    @Override
    public final JMethodDef method(int mods, String returnType, String name) {
        return this.method(mods, JTypes.typeNamed(returnType), name);
    }

    boolean methodCanHaveBody(int mods) {
        return JMod.allAreClear(mods, 5);
    }

    boolean hasInterfaceStyleExtends() {
        return false;
    }

    boolean supportsCompactInitOnly() {
        return true;
    }

    @Override
    public JMethodDef constructor(ArrayList<ClassContent> content, int mods) {
        if (Integer.bitCount(mods & 0x38) > 1) {
            throw new IllegalArgumentException("Only one of 'public', 'protected', or 'private' may be given");
        }
        if (JMod.anyAreSet(mods, -2557)) {
            throw new IllegalArgumentException("Invalid constructor modifier(s) given");
        }
        return this.add(content, new ConstructorJMethodDef(this, mods));
    }

    @Override
    public final JMethodDef constructor(int mods) {
        return this.constructor(this.content, mods);
    }

    @Override
    public JClassDef _class(ArrayList<ClassContent> content, int mods, String name) {
        return this.add(content, new PlainJClassDef(mods, this, name));
    }

    @Override
    public JClassDef _enum(ArrayList<ClassContent> content, int mods, String name) {
        return this.add(content, new EnumJClassDef(mods, this, name));
    }

    @Override
    public JClassDef _interface(ArrayList<ClassContent> content, int mods, String name) {
        return this.add(content, new InterfaceJClassDef(mods, this, name));
    }

    @Override
    public JClassDef annotationInterface(ArrayList<ClassContent> content, int mods, String name) {
        return this.add(content, new AnnotationJClassDef(mods, this, name));
    }

    @Override
    public final JClassDef _class(int mods, String name) {
        return this._class(this.content, mods, name);
    }

    @Override
    public final JClassDef _enum(int mods, String name) {
        return this._enum(this.content, mods, name);
    }

    @Override
    public final JClassDef _interface(int mods, String name) {
        return this._interface(this.content, mods, name);
    }

    @Override
    public final JClassDef annotationInterface(int mods, String name) {
        return this.annotationInterface(this.content, mods, name);
    }

    Iterable<ClassContent> getContent() {
        return this.content;
    }

    JType getExtends() {
        return this._extends;
    }

    Iterable<JType> getImplements() {
        return this._implements;
    }

    abstract Tokens$.KW designation();

    FormatPreferences.Indentation getMemberIndentation() {
        return FormatPreferences.Indentation.MEMBERS_TOP_LEVEL;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeDocComments(writer);
        this.writeComments(writer);
        this.writeAnnotations(writer, FormatPreferences.Space.AFTER_ANNOTATION);
        writer.pushThisType(AbstractJType.of(this.genericType()));
        try {
            this.writeClassHeader(writer);
            this.writeContentBlock(writer);
        }
        finally {
            writer.popThisType(AbstractJType.of(this.genericType()));
        }
    }

    void writeContentBlock(SourceFileWriter sourceFileWriter) throws IOException {
        sourceFileWriter.write(FormatPreferences.Space.BEFORE_BRACE_CLASS);
        sourceFileWriter.write(Tokens$.PUNCT.BRACE.OPEN);
        boolean hasOption = sourceFileWriter.getFormat().hasOption(FormatPreferences.Opt.COMPACT_INIT_ONLY_CLASS);
        if (this.supportsCompactInitOnly() && hasOption && this.content.size() == 1 && this.content.get(0) instanceof InitJBlock) {
            this.writeContent(sourceFileWriter);
            sourceFileWriter.write(Tokens$.PUNCT.BRACE.CLOSE);
        } else {
            sourceFileWriter.pushIndent(this.getMemberIndentation());
            try {
                sourceFileWriter.nl();
                this.writeContent(sourceFileWriter);
            }
            finally {
                sourceFileWriter.popIndent(this.getMemberIndentation());
            }
            sourceFileWriter.nl();
            sourceFileWriter.write(Tokens$.PUNCT.BRACE.CLOSE);
            sourceFileWriter.nl();
        }
    }

    void writeClassHeader(SourceFileWriter sourceFileWriter) throws IOException {
        Iterator<JType> iterator;
        JMod.write(sourceFileWriter, this.mods);
        sourceFileWriter.write(this.designation());
        sourceFileWriter.writeClass(this.name);
        this.writeTypeParams(sourceFileWriter);
        boolean ifExt = this.hasInterfaceStyleExtends();
        if (!ifExt && this._extends != null) {
            sourceFileWriter.write(Tokens$.KW.EXTENDS);
            sourceFileWriter.write(this._extends);
        }
        if (this._implements != null && (iterator = this._implements.iterator()).hasNext()) {
            sourceFileWriter.write(ifExt ? Tokens$.KW.EXTENDS : Tokens$.KW.IMPLEMENTS);
            sourceFileWriter.write(iterator.next());
            while (iterator.hasNext()) {
                sourceFileWriter.write(FormatPreferences.Space.BEFORE_COMMA);
                sourceFileWriter.write(Tokens$.PUNCT.COMMA);
                sourceFileWriter.write(FormatPreferences.Space.AFTER_COMMA);
                sourceFileWriter.write(iterator.next());
            }
        }
    }

    void writeContent(SourceFileWriter sourceFileWriter) throws IOException {
        Iterator<ClassContent> iterator = this.content.iterator();
        if (iterator.hasNext()) {
            iterator.next().write(sourceFileWriter);
            while (iterator.hasNext()) {
                sourceFileWriter.nl();
                iterator.next().write(sourceFileWriter);
            }
        }
    }

    public int getModifiers() {
        return this.mods;
    }

    public boolean hasAllModifiers(int mods) {
        return (this.mods & mods) == mods;
    }

    public boolean hasAnyModifier(int mods) {
        return (this.mods & mods) != 0;
    }
}

