/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.http2.Http2FrameCodec;
import org.glassfish.grizzly.http2.Http2Session;

class Http2State {
    private static final Attribute<Http2State> http2State = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(Http2State.class.getName() + ".state");
    private List<ReadyListener> listeners;
    private final AtomicReference<Status> status = new AtomicReference();
    private final Http2FrameCodec.FrameParsingState frameParsingState = new Http2FrameCodec.FrameParsingState();
    private Http2Session http2Session;
    private boolean isClientHttpUpgradeRequestFinished;
    private boolean isClientPrefaceSent;

    static Http2State get(Connection connection) {
        return http2State.get(connection);
    }

    static boolean isHttp2(Connection connection) {
        Http2State state = http2State.get(connection);
        return state != null && state.isHttp2();
    }

    static Http2State obtain(Connection connection) {
        Http2State state = http2State.get(connection);
        if (state == null) {
            state = Http2State.create(connection);
        }
        return state;
    }

    static Http2State create(Connection connection) {
        Http2State state = new Http2State();
        http2State.set(connection, state);
        return state;
    }

    static void remove(Connection connection) {
        http2State.remove(connection);
    }

    public Http2State() {
        this.status.set(Status.HTTP_UPGRADE);
    }

    public Status getStatus() {
        return this.status.get();
    }

    boolean isNeverHttp2() {
        return this.status.get() == Status.NEVER_HTTP2;
    }

    void setNeverHttp2() {
        this.status.set(Status.NEVER_HTTP2);
    }

    boolean isHttp2() {
        return !this.isNeverHttp2();
    }

    public boolean isReady() {
        return this.status.get() == Status.OPEN;
    }

    public synchronized void addReadyListener(ReadyListener ... readyListeners) {
        if (readyListeners == null) {
            return;
        }
        if (this.isReady()) {
            int len = readyListeners.length;
            for (int i = 0; i < len; ++i) {
                readyListeners[i].ready(this.http2Session);
            }
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ReadyListener>(readyListeners.length + 2);
            }
            int len = readyListeners.length;
            for (int i = 0; i < len; ++i) {
                this.listeners.add(readyListeners[i]);
            }
        }
    }

    void setOpen() {
        this.status.set(Status.OPEN);
        this.notifyReadyListeners();
    }

    boolean isHttpUpgradePhase() {
        return this.status.get() == Status.HTTP_UPGRADE;
    }

    void finishHttpUpgradePhase() {
        this.status.compareAndSet(Status.HTTP_UPGRADE, Status.DIRECT_UPGRADE);
    }

    void setDirectUpgradePhase() {
        this.status.set(Status.DIRECT_UPGRADE);
    }

    Http2FrameCodec.FrameParsingState getFrameParsingState() {
        return this.frameParsingState;
    }

    Http2Session getHttp2Session() {
        return this.http2Session;
    }

    void setHttp2Session(Http2Session http2Session) {
        this.http2Session = http2Session;
        this.http2Session.http2State = this;
    }

    void onClientHttpUpgradeRequestFinished() {
        this.isClientHttpUpgradeRequestFinished = true;
    }

    synchronized boolean tryLockClientPreface() {
        Status s = this.status.get();
        if (!this.isClientPrefaceSent && this.isClientHttpUpgradeRequestFinished && (s == Status.DIRECT_UPGRADE || s == Status.OPEN)) {
            this.isClientPrefaceSent = true;
            return true;
        }
        return false;
    }

    private synchronized void notifyReadyListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ReadyListener listener : this.listeners) {
                listener.ready(this.http2Session);
            }
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public static enum Status {
        NEVER_HTTP2,
        HTTP_UPGRADE,
        DIRECT_UPGRADE,
        OPEN;

    }

    static interface ReadyListener {
        public void ready(Http2Session var1);
    }
}

