/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.glassfish.admingui.common.handlers.Tag;
import org.glassfish.admingui.common.util.GuiUtil;

public class TagSupport
implements Serializable {
    private static final int TAG_NAME_MAP_IDX = 0;
    private static final int PAGE_MAP_IDX = 1;
    public static final String BASE_NODE = "/glassfish/tags";
    public static final String TAG_DATA_KEY = "tagData";

    public static void addTag(String tagName, String tagViewId, String displayName, String user) {
        if (tagName == null) {
            throw new IllegalArgumentException("You cannot add a tag with a null name!");
        }
        if (tagViewId == null) {
            throw new IllegalArgumentException("You cannot tag a page which does not have an ID!");
        }
        tagViewId = TagSupport.normalizeTagViewId(tagViewId);
        if (user == null) {
            user = "anonymous";
        }
        Tag theTag = null;
        List<Tag> tags = TagSupport.queryTags(tagName, tagViewId, null);
        if (tags != null && tags.size() > 0) {
            theTag = tags.get(0);
            if (theTag.containsUser(user)) {
                return;
            }
            theTag.addUser(user);
        } else {
            theTag = new Tag(tagName, tagViewId, displayName, user);
        }
        TagSupport.setTag(theTag);
    }

    private static void setTag(Tag tag) {
        Map<String, List<Tag>>[] maps = TagSupport.getTagMaps();
        if (tag.getUsers() != null && tag.getUsers().size() > 0) {
            TagSupport.setTagInMap(maps[0], TagSupport.normalizeTagName(tag.getTagName()), tag);
            TagSupport.setTagInMap(maps[1], tag.getTagViewId(), tag);
        } else {
            List<Tag> tags = maps[0].get(TagSupport.normalizeTagName(tag.getTagName()));
            tags.remove(tag);
            tags = maps[1].get(tag.getTagViewId());
            tags.remove(tag);
        }
        TagSupport.setTagMaps(maps);
    }

    private static void setTagInMap(Map<String, List<Tag>> map, String key, Tag tag) {
        List<Tag> tagList = map.get(key);
        if (tagList != null) {
            int tagIdx = tagList.indexOf(tag);
            if (tagIdx != -1) {
                tagList.remove(tagIdx);
            }
        } else {
            tagList = new ArrayList<Tag>(1);
            map.put(key, tagList);
        }
        tagList.add(tag);
    }

    private static void setTagMaps(Map<String, List<Tag>>[] maps) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(buf);
            out.writeObject(maps);
            Preferences prefs = Preferences.userRoot().node(BASE_NODE);
            prefs.putByteArray(TAG_DATA_KEY, buf.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to store preference!", ex);
        }
    }

    private static Map<String, List<Tag>>[] getTagMaps() {
        Map[] result = null;
        Preferences prefs = Preferences.userRoot().node(BASE_NODE);
        byte[] tagData = prefs.getByteArray(TAG_DATA_KEY, null);
        if (tagData == null) {
            result = new Map[]{new HashMap(), new HashMap()};
        } else {
            try {
                ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(tagData));
                result = (Map[])stream.readObject();
            }
            catch (InvalidClassException ex) {
                throw new IllegalStateException("Perhaps you have an old Tag storage format?", ex);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to read Tag information!", ex);
            }
        }
        return result;
    }

    public static List<Tag> queryTags(String tagName, String tagViewId, String user) {
        Iterator<Object> it;
        Map<String, List<Tag>>[] maps = TagSupport.getTagMaps();
        List<Object> results = null;
        Tag testTag = null;
        tagViewId = TagSupport.normalizeTagViewId(tagViewId);
        if (tagName != null) {
            results = maps[0].get(TagSupport.normalizeTagName(tagName));
            if (results == null) {
                return null;
            }
            if (tagViewId != null) {
                it = results.iterator();
                while (it.hasNext()) {
                    testTag = (Tag)it.next();
                    if (testTag.getTagViewId().equals(tagViewId)) continue;
                    it.remove();
                }
            }
        } else if (tagViewId != null) {
            results = maps[1].get(tagViewId);
        } else {
            results = new ArrayList();
            Map<String, List<Tag>> map = maps[0];
            for (Map.Entry<String, List<Tag>> e : map.entrySet()) {
                results.addAll((Collection<Object>)e.getValue());
            }
        }
        if (user != null && results != null) {
            it = results.iterator();
            while (it.hasNext()) {
                testTag = (Tag)it.next();
                if (testTag.containsUser(user)) continue;
                it.remove();
            }
        }
        if (results != null && results.size() == 0) {
            results = null;
        }
        return results;
    }

    public static void removeTag(String tagName, String tagViewId, String user) {
        if (tagName == null || tagViewId == null || user == null) {
            throw new IllegalArgumentException("To remove a Tag, you must specify the tagName, tagViewId, and tag owner!");
        }
        List<Tag> results = TagSupport.queryTags(tagName = TagSupport.normalizeTagName(tagName), tagViewId = TagSupport.normalizeTagViewId(tagViewId), user);
        if (results.size() > 0) {
            Tag targetTag = results.get(0);
            targetTag.removeUser(user);
            TagSupport.setTag(targetTag);
        }
    }

    private static String normalizeTagName(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name cannot be null!");
        }
        return tagName.replaceAll("\\s", "").toLowerCase(GuiUtil.guiLocale);
    }

    public static String normalizeTagViewId(String tagViewId) {
        if (tagViewId == null) {
            return null;
        }
        int idx = ((String)(tagViewId = ((String)tagViewId).trim())).indexOf(63);
        Object baseName = idx == -1 ? tagViewId : ((String)tagViewId).substring(0, idx);
        String queryString = idx == -1 ? "" : ((String)tagViewId).substring(idx + 1);
        StringTokenizer tokenizer = new StringTokenizer((String)baseName, "/");
        StringBuilder builder = new StringBuilder(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            builder.append('/');
            builder.append(tokenizer.nextToken());
        }
        baseName = builder.toString();
        if (!((String)baseName).endsWith(".jsf") && (idx = ((String)baseName).lastIndexOf(46)) != -1) {
            baseName = ((String)baseName).substring(0, idx) + ".jsf";
        }
        if (queryString.length() > 0) {
            tokenizer = new StringTokenizer(queryString, "&");
            ArrayList<String> nvps = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                nvps.add(tokenizer.nextToken());
            }
            Collections.sort(nvps);
            builder = new StringBuilder((String)nvps.remove(0));
            for (String nvp : nvps) {
                builder.append('&');
                builder.append(nvp);
            }
            queryString = builder.toString();
        }
        tagViewId = (String)baseName + (String)(queryString.length() > 0 ? "?" + queryString : "");
        return tagViewId;
    }

    public static void main(String[] args) {
        TagSupport.addTag("bar", "deploy.jsf?a=z&c=e", "Display Name", "jane");
        TagSupport.addTag("bar", "/index.jsf?a=z&c=f", "Display Name", "jane");
        TagSupport.addTag("bar", "/index.jsf?a=z&c=e", "Display Name", "jane");
        TagSupport.addTag("bar", "deploy.jsf?a=z&c=g", "Display Name", "jane");
        TagSupport.addTag("bar", "indexdeployjsf?a=z&c=h", "Display Name", "jack");
        TagSupport.addTag("bar", "/index.jsf?deploy=z&c=i", "Display Name", "jack");
        TagSupport.addTag("foo", "/index.jsf?a=z&c=j", "Display Name", "jack");
        TagSupport.addTag("bar", "/index.jsf?a=z&c=e", "Display Name", "jane");
        TagSupport.addTag("bar", "/index.jsf?a=z&c=f", "Display Name", "jane");
        TagSupport.addTag("bar", "deploy.jsf?a=z&c=e", "Display Name", "jane");
        TagSupport.addTag("bar", "/index.jsf?a=z&c=g", "Display Name", "jane");
        TagSupport.addTag("bar", "deploy.jsf?a=z&c=h", "Display Name", "jack");
        TagSupport.addTag("bar", "/index.jsf?a=z&c=i", "Display Name", "jack");
        TagSupport.addTag("foo", "deploy.jsf?a=z&c=j", "Display Name", "jack");
        TagSupport.addTag("foo", "deploy.jsf?a=z&c=k", "Display Name", "jack");
        TagSupport.addTag("bat", "deploy.jsf?a=z&c=l", "Display Name", "jack");
        TagSupport.addTag("foo", "/index.jsf?a=z&c=m", "Display Name", "jack");
        TagSupport.addTag("foo", "deploy.jsf?a=z&c=k", "Display Name", "jack");
        TagSupport.addTag("bat", "deploy.jsf?a=z&c=l", "Display Name", "jack");
        TagSupport.addTag("foo", "deploy.jsf?a=z&c=m", "Display Name", "jack");
        TagSupport.addTag("bat", "deploy.jsf?a=z&c=n", "Display Name", "jack");
        TagSupport.addTag("bat", "/index.jsf?a=z&c=o", "Display Name", "bill");
        TagSupport.addTag("bat", "deploy.jsf?a=z&c=p", "Display Name", "bill");
        TagSupport.addTag("bat", "deploy.jsf?a=z&c=q", "Display Name", "bill");
        TagSupport.addTag("foo", "deploy.jsf?a=z&c=s", "Display Name", "bill");
        TagSupport.addTag("foo", "deploy.jsf?a=z&c=t", "Display Name", "jane");
        TagSupport.addTag("bat", "deploy.jsf?a=z&c=u", "Display Name", "jane");
        TagSupport.addTag("bat", "deploy.jsf?a=z&c=v", "Display Name", "jane");
        List<Tag> results = TagSupport.queryTags(null, null, null);
        if (results != null) {
            for (Tag tag : results) {
                System.out.println("Found==> " + String.valueOf(tag));
            }
        }
    }
}

