/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import java.util.Map;

public abstract class ModulesManager {
    private boolean returnNullContexts;

    protected ModulesManager(boolean returnNullContexts) {
        this.returnNullContexts = returnNullContexts;
    }

    public boolean returnsNullContexts() {
        return this.returnNullContexts;
    }

    public <M> boolean isProtected(M[] template, String authContextID) throws AuthException {
        try {
            if (this.returnNullContexts) {
                return this.hasModules(template, authContextID);
            }
            return true;
        }
        catch (AuthException ae) {
            throw new RuntimeException(ae);
        }
    }

    public abstract <M> boolean hasModules(M[] var1, String var2) throws AuthException;

    public abstract <M> M[] getModules(M[] var1, String var2) throws AuthException;

    public abstract Map<String, Object> getInitProperties(int var1, Map<String, ?> var2);

    public abstract boolean shouldStopProcessingModules(AuthStatus[] var1, int var2, AuthStatus var3);

    public abstract AuthStatus getReturnStatus(AuthStatus[] var1, AuthStatus var2, AuthStatus[] var3, int var4);

    public abstract void refresh();
}

