/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;

public class GetConfigChangesHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public GetConfigChangesHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "GetConfigChangesHandler");
        }
        if (pkt.getType() == 19) {
            this.handleGetConfigChanges(sender, pkt);
        } else if (pkt.getType() == 20) {
            this.handleGetConfigChangesReply(sender, pkt);
        } else {
            this.logger.log(16, "GetConfigChangesHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleGetConfigChanges(BrokerAddress sender, GPacket pkt) {
        long timestamp = (Long)pkt.getProp("TS");
        this.p.receiveConfigChangesRequest(sender, timestamp);
    }

    public void handleGetConfigChangesReply(BrokerAddress sender, GPacket pkt) {
        int status = (Integer)pkt.getProp("S");
        long timestamp = (Long)pkt.getProp("TS");
        String emsg = null;
        int c = 0;
        byte[] buf = null;
        if (status == 200) {
            c = (Integer)pkt.getProp("C");
            if (pkt.getPayload() != null) {
                buf = pkt.getPayload().array();
            }
        } else {
            emsg = (String)pkt.getProp("reason");
            if (emsg == null) {
                emsg = Status.getString(status);
            }
        }
        this.p.receiveConfigChangesReply(sender, timestamp, c, buf, emsg);
    }
}

