/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator.logging;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;

@MessageLogger(projectCode="LITE-EXTENSION-TRANSLATOR-")
public interface LiteExtensionTranslatorLogger
extends BasicLogger {
    public static final LiteExtensionTranslatorLogger LOG = (LiteExtensionTranslatorLogger)Logger.getMessageLogger(LiteExtensionTranslatorLogger.class, (String)Category.LITE_EXTENSION_TRANSLATOR.getName());

    @Message(id=0, value="Unable to instantiate object from class {0} via no-args constructor. The exception was: {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToInstantiateObject(Class<?> var1, String var2, @Cause Throwable var3);

    @Message(id=1, value="Unexpected extension method argument: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unexpectedMethodArgument(Object var1);

    @Message(id=2, value="{0} methods can't declare a parameter of type {1}, found at {2}. Method name - {3}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidMethodParameter(Object var1, Object var2, Object var3, Object var4);

    @Message(id=3, value="Unknown declaration {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unknownDeclaration(Object var1);

    @Message(id=4, value="Observer method without an @Observes parameter: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException missingObservesAnnotation(Object var1);

    @Message(id=5, value="Unknown primitive type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unknownPrimitiveType(Object var1);

    @Message(id=6, value="Zero or more than one parameter of type {0} for method {1} with declaring class {2}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException incorrectParameterCount(String var1, Object var2, Object var3);

    @Message(id=7, value="Unknown query parameter: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unknownQueryParameter(Object var1);

    @Message(id=8, value="Unable to invoke extension method {0} with arguments {1}. The exception was: {2}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToInvokeExtensionMethod(Object var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=9, value="Unable to load class with name {0}. The exception was: {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException cannotLoadClassByName(Object var1, String var2, @Cause Throwable var3);

    @Message(id=10, value="Unrecognized parameter of type {0} declared in class {1}#{2}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidExtensionMethodParameterType(Object var1, Object var2, Object var3);

    @Message(id=11, value="Unknown reflection type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unknownReflectionType(Object var1);

    @Message(id=12, value="Unknown annotation member {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unknownAnnotationMember(Object var1);

    @Message(id=13, value="Not {0}:{1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException kindNotEqual(Object var1, Object var2);

    @Message(id=14, value="Unable to access annotation member(s) for annotation {0}. The exception was: {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException unableToAccessAnnotationMembers(Object var1, String var2, @Cause Throwable var3);

    @Message(id=15, value="Provided type {0} is illegal because it doesn't match an of known annotation member types.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException illegalAnnotationMemberType(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="AnnotationBuilderFactoryImpl wasn't initialized properly before using it. This can be caused by attempted usage outside of build compatible extension cycle. The init process will use a fallback method.", format=Message.Format.MESSAGE_FORMAT)
    public void annotationFactoryInstanceNotInitialized();

    @Message(id=17, value="There was a problem executing Build Compatible Extension method {0} during phase {1}. The exception was: {2}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException problemExecutingExtensionMethod(Object var1, Object var2, String var3, @Cause Throwable var4);
}

