/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.lang.jstl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.glassfish.wasp.taglibs.standard.lang.jstl.BeanInfoManager;
import org.glassfish.wasp.taglibs.standard.lang.jstl.BeanInfoProperty;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Coercions;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Constants;
import org.glassfish.wasp.taglibs.standard.lang.jstl.ELException;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Expression;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Logger;
import org.glassfish.wasp.taglibs.standard.lang.jstl.ValueSuffix;
import org.glassfish.wasp.taglibs.standard.lang.jstl.VariableResolver;

public class ArraySuffix
extends ValueSuffix {
    static Object[] sNoArgs = new Object[0];
    Expression mIndex;

    public Expression getIndex() {
        return this.mIndex;
    }

    public void setIndex(Expression pIndex) {
        this.mIndex = pIndex;
    }

    public ArraySuffix(Expression pIndex) {
        this.mIndex = pIndex;
    }

    Object evaluateIndex(Object pContext, VariableResolver pResolver, Map functions, String defaultPrefix, Logger pLogger) throws ELException {
        return this.mIndex.evaluate(pContext, pResolver, functions, defaultPrefix, pLogger);
    }

    String getOperatorSymbol() {
        return "[]";
    }

    @Override
    public String getExpressionString() {
        return "[" + this.mIndex.getExpressionString() + "]";
    }

    @Override
    public Object evaluate(Object pValue, Object pContext, VariableResolver pResolver, Map functions, String defaultPrefix, Logger pLogger) throws ELException {
        if (pValue == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.CANT_GET_INDEXED_VALUE_OF_NULL, this.getOperatorSymbol());
            }
            return null;
        }
        Object indexVal = this.evaluateIndex(pContext, pResolver, functions, defaultPrefix, pLogger);
        if (indexVal == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.CANT_GET_NULL_INDEX, this.getOperatorSymbol());
            }
            return null;
        }
        if (pValue instanceof Map) {
            Map val = (Map)pValue;
            return val.get(indexVal);
        }
        if (pValue instanceof List || pValue.getClass().isArray()) {
            Integer indexObj = Coercions.coerceToInteger(indexVal, pLogger);
            if (indexObj == null) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.BAD_INDEX_VALUE, this.getOperatorSymbol(), (Object)indexVal.getClass().getName());
                }
                return null;
            }
            if (pValue instanceof List) {
                try {
                    return ((List)pValue).get(indexObj);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    if (pLogger.isLoggingWarning()) {
                        pLogger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, exc, (Object)indexObj);
                    }
                    return null;
                }
                catch (IndexOutOfBoundsException exc) {
                    if (pLogger.isLoggingWarning()) {
                        pLogger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, exc, (Object)indexObj);
                    }
                    return null;
                }
                catch (Exception exc) {
                    if (pLogger.isLoggingError()) {
                        pLogger.logError(Constants.EXCEPTION_ACCESSING_LIST, exc, (Object)indexObj);
                    }
                    return null;
                }
            }
            try {
                return Array.get(pValue, indexObj);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                if (pLogger.isLoggingWarning()) {
                    pLogger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, exc, (Object)indexObj);
                }
                return null;
            }
            catch (IndexOutOfBoundsException exc) {
                if (pLogger.isLoggingWarning()) {
                    pLogger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, exc, (Object)indexObj);
                }
                return null;
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.EXCEPTION_ACCESSING_ARRAY, exc, (Object)indexObj);
                }
                return null;
            }
        }
        String indexStr = Coercions.coerceToString(indexVal, pLogger);
        if (indexStr == null) {
            return null;
        }
        BeanInfoProperty property = BeanInfoManager.getBeanInfoProperty(pValue.getClass(), indexStr, pLogger);
        if (property != null && property.getReadMethod() != null) {
            try {
                return property.getReadMethod().invoke(pValue, sNoArgs);
            }
            catch (InvocationTargetException exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.ERROR_GETTING_PROPERTY, exc.getTargetException(), (Object)indexStr, (Object)pValue.getClass().getName());
                }
                return null;
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.ERROR_GETTING_PROPERTY, exc, (Object)indexStr, (Object)pValue.getClass().getName());
                }
                return null;
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.CANT_FIND_INDEX, indexVal, (Object)pValue.getClass().getName(), (Object)this.getOperatorSymbol());
        }
        return null;
    }
}

