/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import com.sun.data.provider.SortCriteria;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.util.Iterator;
import java.util.Map;

public final class TableSortActionListener
implements ActionListener {
    public void processAction(ActionEvent event) throws AbortProcessingException {
        if (event == null) {
            TableSortActionListener.log("processAction", "Cannot process action, ActionEvent source is null");
            return;
        }
        UIComponent source = (UIComponent)event.getSource();
        TableColumn col = TableSortActionListener.getTableColumnAncestor(source);
        if (col != null) {
            TableSortActionListener.processTableColumn(col, source.getId());
        } else {
            Table table = TableSortActionListener.getTableAncestor(source);
            if (table != null) {
                TableSortActionListener.processTable(table, source.getId());
            } else {
                TableSortActionListener.log("processAction", "Cannot process action, Table is null");
            }
        }
    }

    private static void processTable(Table component, String id) {
        if (component == null) {
            TableSortActionListener.log("processTable", "Cannot process Table action, Table is null");
            return;
        }
        if (id.equals("_clearSortButton") || id.equals("_sortPanelSubmitButton")) {
            Iterator kids = component.getTableRowGroupChildren();
            while (kids.hasNext()) {
                TableRowGroup group = (TableRowGroup)((Object)kids.next());
                group.clearSort();
            }
        }
        if (id.equals("_sortPanelSubmitButton")) {
            TableSortActionListener.customSort(component);
        }
    }

    private static void processTableColumn(TableColumn component, String id) {
        if (component == null) {
            TableSortActionListener.log("processTableColumn", "Cannot process TableColumn action, TableColumn is null");
            return;
        }
        Table table = component.getTableAncestor();
        if (table != null && table.getColumnHeadersCount() > 1) {
            TableRowGroup group = component.getTableRowGroupAncestor();
            TableSortActionListener.setSort(group, id, component.getSortCriteria());
        } else {
            TableSortActionListener.sort(table, id, component.getSortCriteria());
        }
    }

    private static void sort(Table component, String id, SortCriteria criteria) {
        if (component == null || criteria == null) {
            TableSortActionListener.log("sort", "Cannot sort, Table or SortCriteria is null");
            return;
        }
        int index = TableSortActionListener.getNodeIndex(component, criteria.getCriteriaKey());
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            TableColumn col = TableSortActionListener.getTableColumn(group, index);
            if (col != null) {
                TableSortActionListener.setSort(group, id, col.getSortCriteria());
                continue;
            }
            TableSortActionListener.setSort(group, id, null);
        }
    }

    private static void setSort(TableRowGroup component, String id, SortCriteria criteria) {
        if (component == null) {
            TableSortActionListener.log("setSort", "Cannot set sort, TableRowGroup is null");
            return;
        }
        if (id.equals("_addSortButton")) {
            component.addSort(criteria);
        } else if (id.equals("_selectSortButton") || id.equals("_primarySortButton") || id.equals("_primarySortLink")) {
            component.clearSort();
            component.addSort(criteria);
        } else if (id.equals("_toggleSortButton")) {
            if (criteria != null) {
                criteria.setAscending(component.isDescendingSort(criteria));
            }
            component.addSort(criteria);
        } else {
            TableSortActionListener.log("setSort", "Cannot add sort, unknown component Id: " + id);
        }
    }

    private static void customSort(Table component) {
        int index;
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            TableSortActionListener.log("customSort", "Cannot custom sort, embedded panels facet is null");
            return;
        }
        Map map = panels.getFacets();
        UIComponent primarySortColumnMenu = (UIComponent)map.get("_primarySortColumnMenu");
        UIComponent primarySortOrderMenu = (UIComponent)map.get("_primarySortOrderMenu");
        UIComponent secondarySortColumnMenu = (UIComponent)map.get("_secondarySortColumnMenu");
        UIComponent secondarySortOrderMenu = (UIComponent)map.get("_secondarySortOrderMenu");
        UIComponent tertiarySortColumnMenu = (UIComponent)map.get("_tertiarySortColumnMenu");
        UIComponent tertiarySortOrderMenu = (UIComponent)map.get("_tertiarySortOrderMenu");
        if (primarySortColumnMenu != null && primarySortOrderMenu != null && primarySortColumnMenu instanceof DropDown && primarySortOrderMenu instanceof DropDown) {
            index = TableSortActionListener.getNodeIndex(component, (String)((DropDown)primarySortColumnMenu).getSelected());
            TableSortActionListener.setCustomSort(component, index, Boolean.parseBoolean((String)((DropDown)primarySortOrderMenu).getSelected()));
        } else {
            TableSortActionListener.log("customSort", "Cannot set custom sort,primary sort column menu is null");
        }
        if (secondarySortColumnMenu != null && secondarySortOrderMenu != null && secondarySortColumnMenu instanceof DropDown && secondarySortOrderMenu instanceof DropDown) {
            index = TableSortActionListener.getNodeIndex(component, (String)((DropDown)secondarySortColumnMenu).getSelected());
            TableSortActionListener.setCustomSort(component, index, Boolean.parseBoolean((String)((DropDown)secondarySortOrderMenu).getSelected()));
        } else {
            TableSortActionListener.log("customSort", "Cannot set custom sort, secondary sort column menu is null");
        }
        if (tertiarySortColumnMenu != null && tertiarySortOrderMenu != null && tertiarySortColumnMenu instanceof DropDown && tertiarySortOrderMenu instanceof DropDown) {
            index = TableSortActionListener.getNodeIndex(component, (String)((DropDown)tertiarySortColumnMenu).getSelected());
            TableSortActionListener.setCustomSort(component, index, Boolean.parseBoolean((String)((DropDown)tertiarySortOrderMenu).getSelected()));
        } else {
            TableSortActionListener.log("customSort", "Cannot set custom sort,tertiary sort column menu is null");
        }
    }

    private static void setCustomSort(Table component, int index, boolean descending) {
        if (component == null || index < 0) {
            TableSortActionListener.log("setCustomSort", "Cannot set custom sort, Table is null or index < 0");
            return;
        }
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            TableColumn col = TableSortActionListener.getTableColumn(group, index);
            SortCriteria criteria = col != null ? col.getSortCriteria() : null;
            if (criteria != null) {
                criteria.setAscending(!descending);
            }
            group.addSort(criteria);
        }
    }

    private static int getNodeIndex(Table component, String criteriaKey) {
        if (component == null || criteriaKey == null || criteriaKey.length() == 0) {
            TableSortActionListener.log("getNodeIndex", "Cannot obtain node index, Table or sort criteria key is null");
            return -1;
        }
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Integer index = -1;
            Iterator<TableColumn> kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                int result = TableSortActionListener.getNodeIndex(col, criteriaKey, index = Integer.valueOf(index + 1));
                if (result <= -1) continue;
                return result;
            }
        } else {
            TableSortActionListener.log("getNodeIndex", "Cannot obtain node index, TableRowGroup is null");
        }
        return -1;
    }

    private static int getNodeIndex(TableColumn component, String criteriaKey, Integer index) {
        SortCriteria criteria;
        String key;
        if (component == null || criteriaKey == null || criteriaKey.length() == 0) {
            TableSortActionListener.log("getNodeIndex", "Cannot obtain node index, TableColumn or sort criteria key is null");
            return -1;
        }
        int idx = index;
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                int result = TableSortActionListener.getNodeIndex(col, criteriaKey, ++idx);
                if (result <= -1) continue;
                return result;
            }
        }
        if ((key = (criteria = component.getSortCriteria()) != null ? criteria.getCriteriaKey() : null) != null && key.equals(criteriaKey)) {
            return index;
        }
        return -1;
    }

    private static TableColumn getTableColumn(TableRowGroup component, int index) {
        if (component == null) {
            TableSortActionListener.log("getTableColumn", "Cannot obtain TableColumn component, TableRowGroup is null");
            return null;
        }
        int idx = index + 1;
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = kids.next();
            TableColumn result = TableSortActionListener.getTableColumn(col, --idx);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static TableColumn getTableColumn(TableColumn component, int index) {
        if (component == null) {
            TableSortActionListener.log("getTableColumn", "Cannot obtain TableColumn component, TableColumn is null");
            return null;
        }
        int idx = index;
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                TableColumn result = TableSortActionListener.getTableColumn(col, --idx);
                if (result == null) continue;
                return result;
            }
        }
        if (index == 0) {
            return component;
        }
        TableSortActionListener.log("getTableColumn", "Cannot obtain TableColumn component, cannot match node index");
        return null;
    }

    private static Table getTableAncestor(UIComponent component) {
        UIComponent comp = component;
        while (comp != null) {
            if (!((comp = comp.getParent()) instanceof Table)) continue;
            return (Table)comp;
        }
        return null;
    }

    private static TableColumn getTableColumnAncestor(UIComponent component) {
        UIComponent comp = component;
        while (comp != null) {
            if (!((comp = comp.getParent()) instanceof TableColumn)) continue;
            return (TableColumn)comp;
        }
        return null;
    }

    private static void log(String method, String message) {
        Class<TableSortActionListener> clazz = TableSortActionListener.class;
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

