/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Markup;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public final class MarkupRenderer
extends AbstractRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Markup markup = (Markup)component;
        String tagName = markup.getTag();
        if (tagName == null) {
            return;
        }
        if (!markup.isSingleton()) {
            this.writeInsides(markup, context, writer);
        }
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        Markup markup = (Markup)component;
        if (!markup.isSingleton()) {
            super.encodeChildren(context, component);
        }
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Markup markup = (Markup)component;
        String tagName = markup.getTag();
        if (tagName == null) {
            return;
        }
        if (markup.isSingleton()) {
            this.writeInsides(markup, context, writer);
        }
        writer.endElement(tagName);
    }

    private void writeInsides(Markup markup, FacesContext context, ResponseWriter writer) throws IOException {
        String tagName = markup.getTag();
        writer.startElement(tagName, (UIComponent)markup);
        this.writeId(markup, context, writer);
        this.writeStyles(markup, context, writer);
        this.writeExtraAttributes(markup, context, writer);
    }

    private void writeId(Markup markup, FacesContext context, ResponseWriter writer) throws IOException {
        String id = markup.getClientId(context);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
    }

    private void writeStyles(Markup markup, FacesContext context, ResponseWriter writer) throws IOException {
        String style = markup.getStyle();
        String styleClass = markup.getStyleClass();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
    }

    private void writeExtraAttributes(Markup markup, FacesContext context, ResponseWriter writer) throws IOException {
        String extra = markup.getExtraAttributes();
        if (extra != null) {
            RenderingUtilities.renderExtraHtmlAttributes(writer, extra);
        }
        Map attributes = markup.getAttributes();
        Set keys = attributes.keySet();
        for (String key : keys) {
            Object value = attributes.get(key);
            if (value == null || !(value instanceof String)) continue;
            writer.writeAttribute(key, value, null);
        }
    }
}

