/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.filecache;

import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;

public class FileCacheKey
implements Cacheable {
    private static final ThreadCache.CachedTypeIndex<FileCacheKey> CACHE_IDX = ThreadCache.obtainIndex(FileCacheKey.class, (int)16);
    protected String host;
    protected String uri;

    protected FileCacheKey() {
    }

    protected FileCacheKey(String host, String uri) {
        this.host = host;
        this.uri = uri;
    }

    public void recycle() {
        this.host = null;
        this.uri = null;
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static FileCacheKey create(String host, String uri) {
        FileCacheKey key = (FileCacheKey)ThreadCache.takeFromCache(CACHE_IDX);
        if (key != null) {
            key.host = host;
            key.uri = uri;
            return key;
        }
        return new FileCacheKey(host, uri);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileCacheKey other = (FileCacheKey)obj;
        String otherHost = other.host;
        if (this.host == null ? otherHost != null : !this.host.equals(otherHost)) {
            return false;
        }
        String otherUri = other.uri;
        return !(this.uri == null ? otherUri != null : !this.uri.equals(otherUri));
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 23 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        return hash;
    }

    protected String getHost() {
        return this.host;
    }

    protected String getUri() {
        return this.uri;
    }
}

