/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.glassfish.rmic.tools.java.FileClassFile;
import org.glassfish.rmic.tools.java.PathClassFile;
import org.glassfish.rmic.tools.java.ZipClassFile;

public abstract class ClassFile {
    public static ClassFile newClassFile(File file) {
        return new FileClassFile(file);
    }

    public static ClassFile newClassFile(ZipFile zf, ZipEntry ze) {
        return new ZipClassFile(zf, ze);
    }

    public static ClassFile newClassFile(Path path) {
        return Files.exists(path, new LinkOption[0]) ? new PathClassFile(path) : null;
    }

    public abstract boolean isZipped();

    public abstract InputStream getInputStream() throws IOException;

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract String getPath();

    public abstract String getName();

    public abstract String getAbsoluteName();

    public abstract long length();
}

