/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.Extension;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocketApplication;

public abstract class HandShake {
    private HttpRequestPacket.Builder builder;
    private boolean secure;
    private String origin;
    private String serverHostName;
    private int port = 80;
    private String resourcePath;
    private String location;
    private List<String> subProtocol = new ArrayList<String>();
    private List<Extension> extensions = new ArrayList<Extension>();

    public HandShake(URI url) {
        this.builder = (HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().protocol(Protocol.HTTP_1_1)).method(Method.GET).header(Header.Connection, "Upgrade")).upgrade("WebSocket");
        this.resourcePath = url.getPath();
        if ("".equals(this.resourcePath)) {
            this.resourcePath = "/";
        }
        if (url.getQuery() != null) {
            this.resourcePath = this.resourcePath + "?" + url.getQuery();
        }
        this.serverHostName = url.getHost();
        this.secure = "wss://".equals(url.getScheme());
        this.port = url.getPort();
        StringBuilder sb = new StringBuilder(32).append(this.getScheme()).append("://").append(url.getHost());
        this.origin = this.appendPort(sb).toString().toLowerCase(Locale.ENGLISH);
        this.buildLocation();
    }

    public HandShake(HttpRequestPacket request) {
        MimeHeaders mimeHeaders = request.getHeaders();
        this.checkForHeader((HttpHeader)request, "Upgrade", "WebSocket");
        this.checkForHeader((HttpHeader)request, "Connection", "Upgrade");
        this.origin = this.readHeader(mimeHeaders, "Sec-WebSocket-Origin");
        if (this.origin == null) {
            this.origin = this.readHeader(mimeHeaders, "Origin");
        }
        this.determineHostAndPort(mimeHeaders);
        this.subProtocol = this.split(mimeHeaders.getHeader("Sec-WebSocket-Protocol"));
        if (this.serverHostName == null) {
            throw new HandshakeException("Missing required headers for WebSocket negotiation");
        }
        this.resourcePath = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            this.resourcePath = this.resourcePath + "?" + queryString;
        }
        this.buildLocation();
    }

    protected abstract int getVersion();

    protected final void buildLocation() {
        StringBuilder sb = new StringBuilder(this.getScheme() + "://" + this.serverHostName);
        this.appendPort(sb);
        if (this.resourcePath == null || !this.resourcePath.startsWith("/") && !"".equals(this.resourcePath)) {
            sb.append("/");
        }
        sb.append(this.resourcePath);
        this.location = sb.toString();
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrigin() {
        return this.origin;
    }

    public int getPort() {
        return this.port;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public List<String> getSubProtocol() {
        return this.subProtocol;
    }

    public void setSubProtocol(List<String> subProtocol) {
        this.subProtocol = subProtocol;
    }

    private void sanitize(List<String> strings) {
        if (strings != null) {
            for (int i = 0; i < strings.size(); ++i) {
                strings.set(i, strings.get(i) == null ? null : strings.get(i).trim());
            }
        }
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    protected final String joinExtensions(List<Extension> extensions) {
        StringBuilder sb = new StringBuilder();
        for (Extension e : extensions) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(e.toString());
        }
        return sb.toString();
    }

    protected String join(List<String> values) {
        StringBuilder builder = new StringBuilder();
        for (String s : values) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    private void checkForHeader(HttpHeader headers, String header, String validValue) {
        this.validate(header, validValue, headers.getHeader(header));
    }

    private void checkForSubProtocol(HttpResponsePacket headers) {
        if (!this.getSubProtocol().isEmpty()) {
            String value = headers.getHeader("Sec-WebSocket-Protocol");
            boolean found = false;
            if (value != null) {
                TreeSet<String> validValues = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                ArrayList<String> acceptedSubProtocol = new ArrayList<String>(validValues.size());
                validValues.addAll(this.getSubProtocol());
                if (value.contains(",")) {
                    for (String part : value.split(",")) {
                        String protocol = part.trim();
                        if (!validValues.contains(protocol)) continue;
                        acceptedSubProtocol.add(protocol);
                    }
                } else if (validValues.contains(value)) {
                    acceptedSubProtocol.add(value);
                }
                if (!acceptedSubProtocol.isEmpty()) {
                    found = true;
                    this.setSubProtocol(acceptedSubProtocol);
                }
            }
            if (!found) {
                throw new HandshakeException(String.format("Invalid Sec-WebSocket-Protocol header returned: '%s'", value));
            }
        }
    }

    private void validate(String header, String validValue, String value) {
        boolean found = false;
        if (value != null) {
            if (value.contains(",")) {
                for (String part : value.split(",")) {
                    if (!part.trim().equalsIgnoreCase(validValue)) continue;
                    found = true;
                    break;
                }
            } else {
                found = value.equalsIgnoreCase(validValue);
            }
        }
        if (!found) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    private String readHeader(MimeHeaders headers, String name) {
        DataChunk value = headers.getValue(name);
        return value == null || value.isNull() ? null : value.toString();
    }

    private void determineHostAndPort(MimeHeaders headers) {
        int i;
        String header = this.readHeader(headers, "host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.serverHostName = header;
            this.port = 80;
        } else {
            assert (header != null);
            this.serverHostName = header.substring(0, i);
            this.port = Integer.parseInt(header.substring(i + 1));
        }
    }

    public HttpContent composeHeaders() {
        Object host = this.getServerHostName();
        if (this.port != -1 && this.port != 80 && this.port != 443) {
            host = (String)host + ":" + this.getPort();
        }
        this.builder.uri(this.getResourcePath()).header(Header.Host, (String)host);
        if (!this.getSubProtocol().isEmpty()) {
            this.builder.header("Sec-WebSocket-Protocol", this.join(this.getSubProtocol()));
        } else {
            this.builder.removeHeader("Sec-WebSocket-Extensions");
        }
        if (!this.getSubProtocol().isEmpty()) {
            this.builder.header("Sec-WebSocket-Protocol", this.join(this.getSubProtocol()));
        }
        return HttpContent.builder((HttpHeader)this.builder.build()).build();
    }

    public void validateServerResponse(HttpResponsePacket headers) {
        if (101 != headers.getStatus()) {
            throw new HandshakeException(String.format("Response code was not %s: %s %s", 101, headers.getStatus(), headers.getReasonPhrase()));
        }
        this.checkForHeader((HttpHeader)headers, "upgrade", "websocket");
        this.checkForHeader((HttpHeader)headers, "connection", "upgrade");
        this.checkForSubProtocol(headers);
    }

    public void respond(FilterChainContext ctx, WebSocketApplication application, HttpResponsePacket response) {
        List<Extension> intersection;
        response.setProtocol(Protocol.HTTP_1_1);
        response.setStatus(HttpStatus.SWITCHING_PROTOCOLS_101);
        response.setHeader("Upgrade", "websocket");
        response.setHeader("Connection", "Upgrade");
        this.setHeaders(response);
        if (!this.getSubProtocol().isEmpty()) {
            response.setHeader("Sec-WebSocket-Protocol", this.join(application.getSupportedProtocols(this.getSubProtocol())));
        }
        if (!(application.getSupportedExtensions().isEmpty() || this.getExtensions().isEmpty() || (intersection = this.intersection(this.getExtensions(), application.getSupportedExtensions())).isEmpty())) {
            application.onExtensionNegotiation(intersection);
            response.setHeader("Sec-WebSocket-Extensions", this.joinExtensions(intersection));
        }
        ctx.write((Object)HttpContent.builder((HttpHeader)response).build());
    }

    protected abstract void setHeaders(HttpResponsePacket var1);

    protected final List<String> split(String header) {
        if (header == null) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(header.split(","));
        this.sanitize(list);
        return list;
    }

    protected List<Extension> intersection(List<Extension> requested, List<Extension> supported) {
        ArrayList<Extension> intersection = new ArrayList<Extension>(supported.size());
        block0: for (Extension e : requested) {
            for (Extension s : supported) {
                if (!e.getName().equals(s.getName())) continue;
                intersection.add(e);
                continue block0;
            }
        }
        return intersection;
    }

    protected final List<Extension> parseExtensionsHeader(String headerValue) {
        String[] parts;
        ArrayList<Extension> resolved = new ArrayList<Extension>();
        for (String part : parts = headerValue.split(",")) {
            int idx = part.indexOf(59);
            if (idx < 0) {
                resolved.add(new Extension(part.trim()));
                continue;
            }
            String name = part.substring(0, idx);
            Extension e = new Extension(name.trim());
            resolved.add(e);
            this.parseParameters(part.substring(idx + 1).trim(), e.getParameters());
        }
        return resolved;
    }

    protected final void parseParameters(String parameterString, List<Extension.Parameter> parameters) {
        String[] parts;
        for (String part : parts = parameterString.split(";")) {
            int idx = part.indexOf(61);
            if (idx < 0) {
                parameters.add(new Extension.Parameter(part.trim(), null));
                continue;
            }
            parameters.add(new Extension.Parameter(part.substring(0, idx).trim(), part.substring(idx + 1).trim()));
        }
    }

    public void initiate(FilterChainContext ctx) throws IOException {
        ctx.write((Object)this.composeHeaders());
    }

    private StringBuilder appendPort(StringBuilder builder) {
        if (this.isSecure()) {
            if (this.port != 443 && this.port != -1) {
                builder.append(':').append(this.port);
            }
        } else if (this.port != 80 && this.port != -1) {
            builder.append(':').append(this.port);
        }
        return builder;
    }

    private String getScheme() {
        return this.isSecure() ? "ws" : "wss";
    }
}

