/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi;

import com.sun.faces.cdi.ApplicationMapProducer;
import com.sun.faces.cdi.ApplicationProducer;
import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.cdi.ComponentProducer;
import com.sun.faces.cdi.DataModelClassesMapProducer;
import com.sun.faces.cdi.ExternalContextProducer;
import com.sun.faces.cdi.FacesContextProducer;
import com.sun.faces.cdi.FlashProducer;
import com.sun.faces.cdi.FlowMapProducer;
import com.sun.faces.cdi.HeaderMapProducer;
import com.sun.faces.cdi.HeaderValuesMapProducer;
import com.sun.faces.cdi.InitParameterMapProducer;
import com.sun.faces.cdi.InjectionPointGenerator;
import com.sun.faces.cdi.ManagedPropertyProducer;
import com.sun.faces.cdi.RequestCookieMapProducer;
import com.sun.faces.cdi.RequestMapProducer;
import com.sun.faces.cdi.RequestParameterMapProducer;
import com.sun.faces.cdi.RequestParameterValuesMapProducer;
import com.sun.faces.cdi.RequestProducer;
import com.sun.faces.cdi.ResourceHandlerProducer;
import com.sun.faces.cdi.SessionMapProducer;
import com.sun.faces.cdi.SessionProducer;
import com.sun.faces.cdi.ViewMapProducer;
import com.sun.faces.cdi.ViewProducer;
import com.sun.faces.cdi.WebsocketPushContextProducer;
import com.sun.faces.push.WebsocketChannelManager;
import com.sun.faces.push.WebsocketSessionManager;
import com.sun.faces.push.WebsocketUserManager;
import com.sun.faces.util.FacesLogger;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.faces.annotation.ManagedProperty;
import jakarta.faces.model.DataModel;
import jakarta.faces.model.FacesDataModel;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CdiExtension
implements Extension {
    private static final Class<?>[] MOJARRA_MANAGED_BEANS = new Class[]{WebsocketUserManager.class, WebsocketSessionManager.class, WebsocketChannelManager.class, WebsocketChannelManager.ViewScope.class, InjectionPointGenerator.class, WebsocketPushContextProducer.class};
    private Map<Class<?>, Class<? extends DataModel<?>>> forClassToDataModelClass = new HashMap();
    private Set<Type> managedPropertyTargetTypes = new HashSet<Type>();
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        CdiUtils.addAnnotatedTypes(beforeBeanDiscovery, beanManager, MOJARRA_MANAGED_BEANS);
    }

    public <T extends DataModel<?>> void processBean(@Observes ProcessBean<T> processBeanEvent, BeanManager beanManager) {
        block2: {
            try {
                ProcessBean event = processBeanEvent;
                CdiUtils.getAnnotation(beanManager, event.getAnnotated(), FacesDataModel.class).ifPresent(model -> this.forClassToDataModelClass.put(model.forClass(), event.getBean().getBeanClass()));
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                LOGGER.warning("Exception happened during processBean: " + e);
            }
        }
    }

    public <T> void processManagedBean(@Observes ProcessManagedBean<T> processManagedBeanEvent, BeanManager beanManager) {
        block3: {
            try {
                for (AnnotatedField field : processManagedBeanEvent.getAnnotatedBeanClass().getFields()) {
                    Type type = field.getBaseType();
                    if (!field.isAnnotationPresent(ManagedProperty.class) || !(type instanceof Class) && !(type instanceof ParameterizedType)) continue;
                    this.managedPropertyTargetTypes.add(type);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.warning("Exception happened during processManagedBean: " + e);
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        afterBeanDiscovery.addBean((Bean)new ApplicationProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new ApplicationMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new ComponentProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new FlashProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new FlowMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new HeaderMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new HeaderValuesMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new InitParameterMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new RequestParameterMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new RequestParameterValuesMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new RequestProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new RequestMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new ResourceHandlerProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new ExternalContextProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new FacesContextProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new RequestCookieMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new SessionProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new SessionMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new ViewMapProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new ViewProducer(beanManager));
        afterBeanDiscovery.addBean((Bean)new DataModelClassesMapProducer(beanManager));
        for (Type type : this.managedPropertyTargetTypes) {
            afterBeanDiscovery.addBean((Bean)new ManagedPropertyProducer(type, beanManager));
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        ArrayList sortedForDataModelClasses = new ArrayList();
        for (Class<?> clazz : this.forClassToDataModelClass.keySet()) {
            int n = -1;
            boolean added = false;
            for (int i = 0; i < sortedForDataModelClasses.size(); ++i) {
                if (((Class)sortedForDataModelClasses.get(i)).isAssignableFrom(clazz)) {
                    sortedForDataModelClasses.add(i, clazz);
                    added = true;
                    break;
                }
                if (!clazz.isAssignableFrom((Class)sortedForDataModelClasses.get(i))) continue;
                n = i;
            }
            if (added) continue;
            if (n > -1) {
                sortedForDataModelClasses.add(n + 1, clazz);
                continue;
            }
            sortedForDataModelClasses.add(clazz);
        }
        LinkedHashMap linkedForClassToDataModelClass = new LinkedHashMap();
        for (Class clazz : sortedForDataModelClasses) {
            linkedForClassToDataModelClass.put(clazz, this.forClassToDataModelClass.get(clazz));
        }
        this.forClassToDataModelClass = Collections.unmodifiableMap(linkedForClassToDataModelClass);
    }

    public Map<Class<?>, Class<? extends DataModel<?>>> getForClassToDataModelClass() {
        return this.forClassToDataModelClass;
    }
}

