/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyUtil;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class ConcurrencySemaphore {
    private final long MAX_TIME_PERMIT = ConcurrencyUtil.SINGLETON.getConcurrencySemaphoreMaxTimePermit();
    private final long TIMEOUT_BETWEEN_LOG_MESSAGES = ConcurrencyUtil.SINGLETON.getConcurrencySemaphoreLogTimeout();
    private ThreadLocal<Boolean> threadLocal;
    private int noOfThreads;
    private Semaphore semaphore;
    private String logMessageKey;
    private Object outerObject;

    public ConcurrencySemaphore(ThreadLocal<Boolean> threadLocalVarControlIfCurrentThreadHasAcquiredSemaphore, int noOfThreadsAllowedToExecuteInParallel, Semaphore semaphoreOfThreadsAllowedToExecuteInParallel, Object outerObject, String logMessageKey) {
        this.threadLocal = threadLocalVarControlIfCurrentThreadHasAcquiredSemaphore;
        this.noOfThreads = noOfThreadsAllowedToExecuteInParallel;
        this.semaphore = semaphoreOfThreadsAllowedToExecuteInParallel;
        this.outerObject = outerObject;
        this.logMessageKey = logMessageKey;
    }

    public boolean acquireSemaphoreIfAppropriate(boolean useSemaphore) {
        long startTimeAttemptingToAcquireSemaphoreMillis;
        boolean useSemaphoreToSlowDown = useSemaphore;
        if (!useSemaphoreToSlowDown) {
            return false;
        }
        Boolean currentThreadHasAcquiredSemaphoreAlready = this.threadLocal.get();
        if (Boolean.TRUE.equals(currentThreadHasAcquiredSemaphoreAlready)) {
            return false;
        }
        boolean successAcquiringSemaphore = false;
        long dateWhenWeLastSpammedServerLogAboutNotBeingAbleToAcquireOurSemaphore = startTimeAttemptingToAcquireSemaphoreMillis = System.currentTimeMillis();
        try {
            successAcquiringSemaphore = this.semaphore.tryAcquire(this.MAX_TIME_PERMIT, TimeUnit.MILLISECONDS);
            while (!successAcquiringSemaphore) {
                long whileCurrentTimeMillis = System.currentTimeMillis();
                long elapsedTime = whileCurrentTimeMillis - dateWhenWeLastSpammedServerLogAboutNotBeingAbleToAcquireOurSemaphore;
                if (elapsedTime > this.TIMEOUT_BETWEEN_LOG_MESSAGES) {
                    String outerObjectString = this.outerObject.toString();
                    String threadName = Thread.currentThread().getName();
                    String logMessage = TraceLocalization.buildMessage(this.logMessageKey, new Object[]{threadName, startTimeAttemptingToAcquireSemaphoreMillis, this.noOfThreads, outerObjectString});
                    AbstractSessionLog.getLog().log(7, "cache", logMessage, (Object)threadName);
                    dateWhenWeLastSpammedServerLogAboutNotBeingAbleToAcquireOurSemaphore = whileCurrentTimeMillis;
                }
                successAcquiringSemaphore = this.semaphore.tryAcquire(this.MAX_TIME_PERMIT, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interrupted) {
            AbstractSessionLog.getLog().logThrowable(7, "cache", interrupted);
            throw ConcurrencyException.waitWasInterrupted(interrupted.getMessage());
        }
        finally {
            this.threadLocal.set(successAcquiringSemaphore);
        }
        return successAcquiringSemaphore;
    }

    public void releaseSemaphoreAllowOtherThreadsToStartDoingObjectBuilding(boolean semaphoreWasAcquired) {
        if (semaphoreWasAcquired) {
            this.semaphore.release();
            this.threadLocal.set(Boolean.FALSE);
        }
    }
}

