/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.migration.archiver.deserializer;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.XMLDeserializer;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BaseXMLDeserializer
implements XMLDeserializer,
DocumentHandler,
DTDHandler,
ErrorHandler {
    protected Object InitialObject;
    protected Parser Parser;
    public Locator TheLocator;
    protected InputSource TheSource;
    public StringBuffer TheCharacters = new StringBuffer();

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.TheLocator = locator;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String name) throws SAXException {
        this.TheCharacters.delete(0, this.TheCharacters.length());
    }

    @Override
    public void endDocument() throws SAXException {
        this.freeResources();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.TheCharacters.append(ch, start, length);
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
        this.TheCharacters.delete(0, this.TheCharacters.length());
    }

    @Override
    public void startDocument() throws SAXException {
        this.freeResources();
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.commonErrorProcessor(exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.commonErrorProcessor(exception);
    }

    @Override
    public void setInitialObject(Object obj) {
        this.InitialObject = obj;
    }

    public void freeResources() {
        this.TheCharacters.delete(0, this.TheCharacters.length());
    }

    public String getCharacters() {
        for (int lOffset = 0; lOffset < this.TheCharacters.length(); ++lOffset) {
            if (lOffset + 2 < this.TheCharacters.length() && this.TheCharacters.substring(lOffset, lOffset + 2).equals("\\n")) {
                this.TheCharacters.delete(lOffset, lOffset + 2);
                continue;
            }
            if (this.TheCharacters.charAt(lOffset) != '\n') continue;
            this.TheCharacters.deleteCharAt(lOffset);
        }
        return this.TheCharacters.toString();
    }

    public int Begin() throws SAXException {
        try {
            if (this.Parser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                this.Parser = factory.newSAXParser().getParser();
                this.Parser.setDocumentHandler(this);
                this.Parser.setDTDHandler(this);
                this.Parser.setErrorHandler(this);
            }
        }
        catch (ParserConfigurationException e1) {
            SAXException classError = new SAXException(e1.getMessage());
            throw classError;
        }
        return 1;
    }

    public void commonErrorProcessor(SAXParseException error) throws SAXException {
        throw error;
    }

    public Object XlateObject() throws SAXException, IOException {
        this.Begin();
        this.Parser.parse(this.TheSource);
        return this.InitialObject;
    }

    public void setSource(InputSource source) {
        this.TheSource = source;
    }

    public Object XlateObject(InputStream stream) throws SAXException, IOException {
        this.Begin();
        InputSource is = new InputSource(stream);
        is.setSystemId("archiverNoID");
        this.setSource(is);
        this.Parser.parse(this.TheSource);
        return this.InitialObject;
    }

    public void DumpStatus() {
        System.out.println("Dump Status from class BaseXMLSerializer");
        System.out.println("The initial object is an instance of " + this.InitialObject.getClass().getName());
        System.out.println("The initial object state " + this.InitialObject.toString());
        System.out.println("The current stream dump is " + this.TheCharacters);
        System.out.println("Dump Status from class BaseXMLSerializer - END");
    }
}

