/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="connector-connection-pool")
@PerLookup
@I18n(value="create.connector.connection.pool")
public class ConnectorConnectionPoolManager
implements ResourceManager {
    @Inject
    private Applications applications;
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ServerEnvironment environment;
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ConnectorConnectionPoolManager.class);
    private String raname;
    private String connectiondefinition;
    private String steadypoolsize = "8";
    private String maxpoolsize = "32";
    private String maxwait = "60000";
    private String poolresize = "2";
    private String idletimeout = "300";
    private String isconnectvalidatereq = Boolean.FALSE.toString();
    private String failconnection = Boolean.FALSE.toString();
    private String validateAtmostOncePeriod = "0";
    private String connectionLeakTimeout = "0";
    private String connectionLeakReclaim = Boolean.FALSE.toString();
    private String connectionCreationRetryAttempts = "0";
    private String connectionCreationRetryInterval = "10";
    private String lazyConnectionEnlistment = Boolean.FALSE.toString();
    private String lazyConnectionAssociation = Boolean.FALSE.toString();
    private String associateWithThread = Boolean.FALSE.toString();
    private String matchConnections = Boolean.FALSE.toString();
    private String maxConnectionUsageCount = "0";
    private String ping = Boolean.FALSE.toString();
    private String pooling = Boolean.TRUE.toString();
    private String transactionSupport;
    private String description;
    private String poolname;

    public String getResourceType() {
        return "connector-connection-pool";
    }

    public ResourceStatus create(Resources resources, ResourceAttributes attributes, final Properties properties, String target) throws Exception {
        this.setParams(attributes);
        ResourceStatus validationStatus = this.isValid(resources, true);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return ConnectorConnectionPoolManager.this.createResource(param, properties);
                }
            }, (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(ConnectorConnectionPoolManager.class.getName()).log(Level.SEVERE, "create-connector-connection-pool failed", tfe);
            String msg = I18N.getLocalString("create.connector.connection.pool.fail", "Connector connection pool {0} create failed: {1}", new Object[]{this.poolname}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        String msg = I18N.getLocalString("create.connector.connection.pool.success", "Connector connection pool {0} created successfully", new Object[]{this.poolname});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean requiresNewTransaction) {
        ResourceStatus status = new ResourceStatus(0, "Validation Successful");
        if (this.poolname == null) {
            String msg = I18N.getLocalString("create.connector.connection.pool.noJndiName", "No pool name defined for connector connection pool.");
            return new ResourceStatus(1, msg);
        }
        SimpleJndiName jndiName = new SimpleJndiName(this.poolname);
        if (resources.getResourceByName(ConnectorConnectionPool.class, jndiName) != null) {
            String errMsg = I18N.getLocalString("create.connector.connection.pool.duplicate", "A resource named {0} already exists.", new Object[]{this.poolname});
            return new ResourceStatus(1, errMsg);
        }
        if (this.environment.isDas() && requiresNewTransaction) {
            if (this.applications == null) {
                String msg = I18N.getLocalString("noApplications", "No applications found.");
                return new ResourceStatus(1, msg);
            }
            try {
                status = this.validateConnectorConnPoolAttributes(this.raname, this.connectiondefinition);
                if (status.getStatus() == 1) {
                    return status;
                }
            }
            catch (ConnectorRuntimeException cre) {
                Logger.getLogger(ConnectorConnectionPoolManager.class.getName()).log(Level.SEVERE, "Could not find connection definitions from ConnectorRuntime for resource adapter " + this.raname, cre);
                String msg = I18N.getLocalString("create.connector.connection.pool.noConnDefs", "Could not find connection definitions for resource adapter {0}", new Object[]{this.raname}) + " " + cre.getLocalizedMessage();
                return new ResourceStatus(1, msg);
            }
        }
        return status;
    }

    private ConnectorConnectionPool createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ConnectorConnectionPool newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private ConnectorConnectionPool createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ConnectorConnectionPool newResource = (ConnectorConnectionPool)param.createChild(ConnectorConnectionPool.class);
        newResource.setResourceAdapterName(this.raname);
        newResource.setConnectionDefinitionName(this.connectiondefinition);
        if (this.validateAtmostOncePeriod != null) {
            newResource.setValidateAtmostOncePeriodInSeconds(this.validateAtmostOncePeriod);
        }
        newResource.setSteadyPoolSize(this.steadypoolsize);
        newResource.setPoolResizeQuantity(this.poolresize);
        newResource.setMaxWaitTimeInMillis(this.maxwait);
        newResource.setMaxPoolSize(this.maxpoolsize);
        if (this.maxConnectionUsageCount != null) {
            newResource.setMaxConnectionUsageCount(this.maxConnectionUsageCount);
        }
        newResource.setMatchConnections(this.matchConnections);
        if (this.lazyConnectionEnlistment != null) {
            newResource.setLazyConnectionEnlistment(this.lazyConnectionEnlistment);
        }
        if (this.lazyConnectionAssociation != null) {
            newResource.setLazyConnectionAssociation(this.lazyConnectionAssociation);
        }
        if (this.isconnectvalidatereq != null) {
            newResource.setIsConnectionValidationRequired(this.isconnectvalidatereq);
        }
        newResource.setIdleTimeoutInSeconds(this.idletimeout);
        newResource.setFailAllConnections(this.failconnection);
        if (this.connectionLeakTimeout != null) {
            newResource.setConnectionLeakTimeoutInSeconds(this.connectionLeakTimeout);
        }
        if (this.connectionLeakReclaim != null) {
            newResource.setConnectionLeakReclaim(this.connectionLeakReclaim);
        }
        if (this.connectionCreationRetryInterval != null) {
            newResource.setConnectionCreationRetryIntervalInSeconds(this.connectionCreationRetryInterval);
        }
        if (this.connectionCreationRetryAttempts != null) {
            newResource.setConnectionCreationRetryAttempts(this.connectionCreationRetryAttempts);
        }
        if (this.associateWithThread != null) {
            newResource.setAssociateWithThread(this.associateWithThread);
        }
        if (this.pooling != null) {
            newResource.setPooling(this.pooling);
        }
        if (this.ping != null) {
            newResource.setPing(this.ping);
        }
        if (this.transactionSupport != null) {
            newResource.setTransactionSupport(this.transactionSupport);
        }
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setName(this.poolname);
        if (properties != null) {
            for (String propertyName : properties.stringPropertyNames()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName(propertyName);
                prop.setValue(properties.getProperty(propertyName));
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setParams(ResourceAttributes attrList) {
        this.raname = attrList.getString("resource-adapter-name");
        this.connectiondefinition = attrList.getString("connection-definition-name");
        this.steadypoolsize = attrList.getString("steady-pool-size");
        this.maxpoolsize = attrList.getString("max-pool-size");
        this.maxwait = attrList.getString("max-wait-time-in-millis");
        this.poolresize = attrList.getString("pool-resize-quantity");
        this.idletimeout = attrList.getString("idle-timeout-in-seconds");
        this.isconnectvalidatereq = attrList.getString("is-connection-validation-required");
        this.failconnection = attrList.getString("fail-all-connections");
        this.validateAtmostOncePeriod = attrList.getString("validate-atmost-once-period-in-seconds");
        this.connectionLeakTimeout = attrList.getString("connection-leak-timeout-in-seconds");
        this.connectionLeakReclaim = attrList.getString("connection-leak-reclaim");
        this.connectionCreationRetryAttempts = attrList.getString("connection-creation-retry-attempts");
        this.connectionCreationRetryInterval = attrList.getString("connection-creation-retry-interval-in-seconds");
        this.lazyConnectionEnlistment = attrList.getString("lazy-connection-enlistment");
        this.lazyConnectionAssociation = attrList.getString("lazy-connection-association");
        this.associateWithThread = attrList.getString("associate-with-thread");
        this.matchConnections = attrList.getString("match-connections");
        this.maxConnectionUsageCount = attrList.getString("max-connection-usage-count");
        this.description = attrList.getString(DESCRIPTION);
        this.poolname = attrList.getString("name");
        this.pooling = attrList.getString("pooling");
        this.ping = attrList.getString("ping");
        this.transactionSupport = attrList.getString("transaction-support");
    }

    private ResourceStatus validateConnectorConnPoolAttributes(String raName, String connDef) throws ConnectorRuntimeException {
        ResourceStatus status = this.isValidRAName(raName);
        if (status.getStatus() == 0 && !this.isValidConnectionDefinition(connDef, raName)) {
            String msg = I18N.getLocalString("admin.mbeans.rmb.invalid_ra_connectdef_not_found", "Invalid connection definition. Connector Module with connection definition {0} not found.", new Object[]{connDef});
            status = new ResourceStatus(1, msg);
        }
        return status;
    }

    private ResourceStatus isValidRAName(String raName) {
        ResourceStatus status = new ResourceStatus(0, "");
        if (raName == null || raName.equals("")) {
            String msg = I18N.getLocalString("admin.mbeans.rmb.null_res_adapter", "Resource Adapter Name is null.");
            status = new ResourceStatus(1, msg);
        } else if (!ConnectorsUtil.getNonJdbcSystemRars().contains(raName)) {
            int indx = raName.indexOf("#");
            if (indx != -1) {
                String appName = raName.substring(0, indx);
                Application app = (Application)this.applications.getModule(Application.class, appName);
                if (app == null) {
                    String msg = I18N.getLocalString("admin.mbeans.rmb.invalid_ra_app_not_found", "Invalid raname. Application with name {0} not found.", new Object[]{appName});
                    status = new ResourceStatus(1, msg);
                }
            } else {
                Application app = (Application)this.applications.getModule(Application.class, raName);
                if (app == null) {
                    String msg = I18N.getLocalString("admin.mbeans.rmb.invalid_ra_cm_not_found", "Invalid raname. Connector Module with name {0} not found.", new Object[]{raName});
                    status = new ResourceStatus(1, msg);
                }
            }
        }
        return status;
    }

    private boolean isValidConnectionDefinition(String connectionDef, String raName) throws ConnectorRuntimeException {
        String[] names;
        for (String name : names = this.connectorRuntime.getConnectionDefinitionNames(raName)) {
            if (!name.equals(connectionDef)) continue;
            return true;
        }
        return false;
    }

    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setParams(attributes);
        ResourceStatus status = validate ? this.isValid(resources, false) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }
}

