/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

class ModuleDefinitionCacheSingleton {
    private static ModuleDefinitionCacheSingleton _instance;
    private static final ReentrantLock slock;
    private final ReentrantLock lock = new ReentrantLock();
    private Map<URI, ModuleDefinition> cachedData = new HashMap<URI, ModuleDefinition>();
    private boolean cacheInvalidated = false;

    private ModuleDefinitionCacheSingleton() {
        try {
            this.loadCachedData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ModuleDefinitionCacheSingleton getInstance() {
        slock.lock();
        try {
            if (_instance == null) {
                _instance = new ModuleDefinitionCacheSingleton();
            }
            ModuleDefinitionCacheSingleton moduleDefinitionCacheSingleton = _instance;
            return moduleDefinitionCacheSingleton;
        }
        finally {
            slock.unlock();
        }
    }

    public void cacheModuleDefinition(URI uri, ModuleDefinition md) {
        this.lock.lock();
        try {
            if (!this.cachedData.containsKey(uri)) {
                this.cacheInvalidated = true;
            }
            this.cachedData.put(uri, md);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(URI uri) {
        this.lock.lock();
        try {
            if (this.cachedData.remove(uri) != null) {
                this.cacheInvalidated = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void loadCachedData() throws Exception {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (!io.exists()) {
            return;
        }
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.INFO, this.getClass().getSimpleName(), "loadCachedData", "HK2 cache file = {0}", new Object[]{io});
        }
        try (ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream((InputStream)new FileInputStream(io), this.getBufferSize())));){
            this.cachedData = (Map)stream.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCache() throws IOException {
        this.lock.lock();
        try {
            if (!this.cacheInvalidated) {
                return;
            }
            String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
            if (cacheLocation == null) {
                return;
            }
            File io = new File(cacheLocation, "inhabitants");
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.INFO, this.getClass().getSimpleName(), "saveCache", "HK2 cache file = {0}", new Object[]{io});
            }
            if (io.exists()) {
                io.delete();
            }
            io.createNewFile();
            HashMap<URI, ModuleDefinition> data = new HashMap<URI, ModuleDefinition>();
            for (ModuleDefinition m : this.cachedData.values()) {
                data.put(m.getLocations()[0], m);
            }
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(io)), this.getBufferSize()));
            os.writeObject(data);
            os.close();
            this.cacheInvalidated = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getBufferSize() {
        int bufsize = 8192;
        try {
            bufsize = Integer.valueOf(this.getProperty("com.sun.enterprise.hk2.cacheIoBufferSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "getBufferSize", "bufsize = {0}", new Object[]{bufsize});
        }
        return bufsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDefinition get(URI uri) {
        this.lock.lock();
        try {
            ModuleDefinition md;
            ModuleDefinition moduleDefinition = md = this.cachedData.get(uri);
            return moduleDefinition;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidate() {
        this.cacheInvalidated = true;
    }

    public boolean isCacheInvalidated() {
        return this.cacheInvalidated;
    }

    private String getProperty(String property) {
        BundleContext bctx = null;
        try {
            bctx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String value = bctx != null ? bctx.getProperty(property) : null;
        return value != null ? value : System.getProperty(property);
    }

    static {
        slock = new ReentrantLock();
    }
}

