/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.protocol.MessageMediatorImpl;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.protocol.MessageParser;
import com.sun.corba.ee.spi.protocol.RequestId;
import com.sun.corba.ee.spi.trace.Giop;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.COMM_FAILURE;

@Transport
@Giop
public class MessageParserImpl
implements MessageParser {
    private static final int NUM_BYTES_IN_INTEGER = 4;
    private static final int MESSAGE_LENGTH_INDEX = 8;
    private static final int MESSAGE_FLAG_INDEX = 6;
    private final ORB orb;
    private boolean expectingMoreData;
    private boolean moreBytesToParse;
    private int nextMsgStartPos;
    private int sizeNeeded;
    private List<RequestId> fragmentList;
    private ByteBuffer msgByteBuffer;
    private ByteBuffer remainderBuffer;
    private MessageMediator messageMediator;
    private Connection connection;
    private boolean expectingFragments;

    public MessageParserImpl(ORB orb) {
        this.orb = orb;
        this.expectingMoreData = false;
        this.moreBytesToParse = false;
        this.nextMsgStartPos = 0;
        this.fragmentList = new LinkedList<RequestId>();
        this.sizeNeeded = orb.getORBData().getReadByteBufferSize();
    }

    public MessageParserImpl(ORB orb, Connection connection) {
        this(orb);
        this.connection = connection;
    }

    @Override
    @Transport
    public ByteBuffer getNewBufferAndCopyOld(ByteBuffer byteBuffer) {
        ByteBuffer newByteBuffer = null;
        byteBuffer.position(this.getNextMessageStartPosition());
        newByteBuffer = this.orb.getByteBufferPool().reAllocate(byteBuffer, this.getSizeNeeded());
        this.setNextMessageStartPosition(0);
        return newByteBuffer;
    }

    @Override
    public boolean isExpectingMoreData() {
        return this.expectingMoreData;
    }

    @Override
    public boolean isExpectingFragments() {
        return this.expectingFragments;
    }

    @Override
    public ByteBuffer getMsgByteBuffer() {
        return this.msgByteBuffer;
    }

    @Override
    public void offerBuffer(ByteBuffer buffer) {
        this.msgByteBuffer = null;
        this.messageMediator = null;
        if (buffer == null) {
            return;
        }
        if (!this.containsFullHeader(buffer) || !this.containsFullMessage(buffer)) {
            this.remainderBuffer = buffer;
        } else {
            this.remainderBuffer = this.splitAndReturnRemainder(buffer, this.getTotalMessageLength(buffer));
            MessageBase message = MessageBase.parseGiopHeader(this.orb, this.connection, buffer, 0);
            this.messageMediator = new MessageMediatorImpl(this.orb, this.connection, message, buffer);
            this.msgByteBuffer = buffer;
            this.expectingFragments = message.moreFragmentsToFollow();
        }
    }

    private ByteBuffer splitAndReturnRemainder(ByteBuffer buffer, int splitPosition) {
        assert (splitPosition <= buffer.limit());
        if (buffer.limit() == splitPosition) {
            return null;
        }
        int oldPosition = buffer.position();
        buffer.position(splitPosition);
        ByteBuffer remainderBuffer = buffer.slice();
        buffer.position(oldPosition);
        buffer.limit(splitPosition);
        return remainderBuffer;
    }

    private boolean containsFullHeader(ByteBuffer buffer) {
        return buffer.remaining() >= 12;
    }

    private boolean containsFullMessage(ByteBuffer buffer) {
        return this.containsFullHeader(buffer) && buffer.remaining() >= this.getTotalMessageLength(buffer);
    }

    private int getTotalMessageLength(ByteBuffer buffer) {
        return 12 + this.getMessageBodyLength(buffer);
    }

    private int getMessageBodyLength(ByteBuffer buffer) {
        buffer.order(this.getByteOrder(buffer.get(6)));
        return buffer.getInt(8);
    }

    private ByteOrder getByteOrder(byte messageFlag) {
        return (messageFlag & 1) == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ByteBuffer getRemainderBuffer() {
        return this.remainderBuffer;
    }

    @Override
    public MessageMediator getMessageMediator() {
        return this.messageMediator;
    }

    @Override
    public void checkTimeout(long timeSinceLastInput) {
        if (this.isMidMessage() && this.timeLimitExceeded(timeSinceLastInput)) {
            throw new COMM_FAILURE();
        }
    }

    private boolean timeLimitExceeded(long timeSinceLastInput) {
        return timeSinceLastInput > 6000L;
    }

    private boolean isMidMessage() {
        return this.expectingFragments || this.remainderBuffer != null && !this.containsFullMessage(this.remainderBuffer);
    }

    @Override
    @Transport
    public Message parseBytes(ByteBuffer byteBuffer, Connection connection) {
        this.expectingMoreData = false;
        this.remainderBuffer = byteBuffer;
        MessageBase message = null;
        int bytesInBuffer = byteBuffer.limit() - this.nextMsgStartPos;
        if (bytesInBuffer >= 12) {
            message = MessageBase.parseGiopHeader(this.orb, connection, byteBuffer, this.nextMsgStartPos);
            if (bytesInBuffer >= message.getSize()) {
                int savedLimit = byteBuffer.limit();
                byteBuffer.position(this.nextMsgStartPos).limit(this.nextMsgStartPos + message.getSize());
                this.msgByteBuffer = byteBuffer.slice();
                this.nextMsgStartPos = byteBuffer.limit();
                byteBuffer.position(this.nextMsgStartPos).limit(savedLimit);
                if (message.supportsFragments()) {
                    if (message.moreFragmentsToFollow()) {
                        this.addRequestIdToFragmentList(message, this.msgByteBuffer);
                    } else if (this.isEndOfFragmentList(message)) {
                        this.removeRequestIdFromFragmentList(message, this.msgByteBuffer);
                    }
                    this.expectingMoreData = this.stillLookingForFragments();
                }
                this.moreBytesToParse = byteBuffer.hasRemaining();
                if (!this.moreBytesToParse) {
                    byteBuffer.limit(byteBuffer.capacity());
                }
                this.sizeNeeded = this.orb.getORBData().getReadByteBufferSize();
            } else {
                this.moreBytesToParse = false;
                this.expectingMoreData = true;
                byteBuffer.position(byteBuffer.limit()).limit(byteBuffer.capacity());
                this.sizeNeeded = message.getSize();
                message = null;
            }
        } else {
            this.moreBytesToParse = false;
            this.expectingMoreData = true;
            byteBuffer.position(byteBuffer.limit()).limit(byteBuffer.capacity());
            this.sizeNeeded = this.orb.getORBData().getReadByteBufferSize();
        }
        return message;
    }

    private boolean stillLookingForFragments() {
        return this.fragmentList.size() > 0;
    }

    private boolean isEndOfFragmentList(Message message) {
        return message.getType() == 7 || message.getType() == 2;
    }

    private void removeRequestIdFromFragmentList(Message message, ByteBuffer byteBuffer) {
        RequestId requestId = MessageBase.getRequestIdFromMessageBytes(message, byteBuffer);
        if (this.fragmentList.size() <= 0 || this.fragmentList.remove(requestId)) {
            // empty if block
        }
    }

    private void addRequestIdToFragmentList(Message message, ByteBuffer byteBuffer) {
        RequestId requestId = MessageBase.getRequestIdFromMessageBytes(message, byteBuffer);
        if (!this.fragmentList.contains(requestId)) {
            this.fragmentList.add(requestId);
        }
    }

    @Override
    public boolean hasMoreBytesToParse() {
        return this.moreBytesToParse;
    }

    @Override
    public void setNextMessageStartPosition(int position) {
        this.nextMsgStartPos = position;
    }

    @Override
    public int getNextMessageStartPosition() {
        return this.nextMsgStartPos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringPrefix()).append("]");
        return sb.toString();
    }

    private String toStringPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageParserImpl[nextMsgStartPos=").append(this.nextMsgStartPos).append(", expectingMoreData=").append(this.expectingMoreData);
        sb.append(", moreBytesToParse=").append(this.moreBytesToParse).append(", fragmentList size=").append(this.fragmentList.size());
        sb.append(", size needed=").append(this.sizeNeeded).append("]");
        return sb.toString();
    }

    @Override
    public int getSizeNeeded() {
        return this.sizeNeeded;
    }
}

