/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.LicenseDescriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;

public class DescriptorFactory {
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private static Map<String, Class<? extends Descriptor>> descriptorClasses;

    protected DescriptorFactory() {
    }

    private static void initMapping() {
        descriptorClasses = new HashMap<String, Class<? extends Descriptor>>();
        DescriptorFactory.register(new XMLElement("application-param"), EnvironmentProperty.class);
        DescriptorFactory.register(new XMLElement("connector"), ConnectorDescriptor.class);
        DescriptorFactory.register(new XMLElement("outbound-resourceadapter"), OutboundResourceAdapter.class);
        DescriptorFactory.register(new XMLElement("inbound-resourceadapter"), InboundResourceAdapter.class);
        DescriptorFactory.register(new XMLElement("resourceadapter"), OutboundResourceAdapter.class);
        DescriptorFactory.register(new XMLElement("authentication-mechanism"), AuthMechanism.class);
        DescriptorFactory.register(new XMLElement("security-permission"), SecurityPermission.class);
        DescriptorFactory.register(new XMLElement("license"), LicenseDescriptor.class);
        DescriptorFactory.register(new XMLElement("config-property"), ConnectorConfigProperty.class);
        DescriptorFactory.register(new XMLElement("required-config-property"), ConnectorConfigProperty.class);
        DescriptorFactory.register(new XMLElement("messagelistener"), MessageListener.class);
        DescriptorFactory.register(new XMLElement("activationspec"), MessageListener.class);
        DescriptorFactory.register(new XMLElement("adminobject"), AdminObject.class);
        DescriptorFactory.register(new XMLElement("connection-definition"), ConnectionDefDescriptor.class);
        DescriptorFactory.register(new XMLElement("service-ref"), ServiceReferenceDescriptor.class);
        DescriptorFactory.register(new XMLElement("port-info"), ServiceRefPortInfo.class);
        DescriptorFactory.register(new XMLElement("stub-property"), NameValuePairDescriptor.class);
        DescriptorFactory.register(new XMLElement("call-property"), NameValuePairDescriptor.class);
        DescriptorFactory.register(new XMLElement("persistence-unit"), PersistenceUnitDescriptor.class);
        DescriptorFactory.register(new XMLElement("persistence-context-ref"), EntityManagerReferenceDescriptor.class);
        DescriptorFactory.register(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceDescriptor.class);
    }

    public static void register(XMLElement xmlElement, Class<? extends Descriptor> clazz) {
        LOG.log(Level.CONFIG, "Registering {0} to handle xml path {1}", new Object[]{clazz, xmlElement});
        descriptorClasses.put(xmlElement.getQName(), clazz);
    }

    public static <T extends Descriptor> T getDescriptor(String xmlPath) {
        try {
            Class<T> c = DescriptorFactory.getDescriptorClass(xmlPath);
            if (c == null) {
                return null;
            }
            return (T)((Descriptor)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create a descriptor instance for " + xmlPath, e);
        }
    }

    private static <T extends Descriptor> Class<T> getDescriptorClass(String xmlPath) {
        String xpathPart = xmlPath;
        do {
            LOG.log(Level.FINEST, "Looking descriptor class for {0}", xpathPart);
            Class<? extends Descriptor> clazz = descriptorClasses.get(xpathPart);
            if (clazz == null) continue;
            return clazz;
        } while ((xpathPart = xpathPart.indexOf(47) == -1 ? null : xpathPart.substring(xpathPart.indexOf(47) + 1)) != null);
        throw new IllegalStateException("No descriptor registered for " + xmlPath);
    }

    static {
        DescriptorFactory.initMapping();
    }
}

