/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ServiceLocator;

public class InjectionPointHelper {
    private final ServiceLocator services;
    private final ComponentEnvManager compEnvManager;
    private final GlassfishNamingManager namingManager;

    public InjectionPointHelper(ServiceLocator serviceLocator) {
        this.services = serviceLocator;
        this.compEnvManager = (ComponentEnvManager)this.services.getService(ComponentEnvManager.class, new Annotation[0]);
        this.namingManager = (GlassfishNamingManager)this.services.getService(GlassfishNamingManager.class, new Annotation[0]);
    }

    public Object resolveInjectionPoint(Member member, Application app) throws NamingException {
        Annotation[] annotations;
        if (member == null) {
            throw new IllegalArgumentException("Member cannot be null.");
        }
        if (app == null) {
            throw new IllegalArgumentException("Application cannot be null.");
        }
        Field field = null;
        Method method = null;
        if (member instanceof Field) {
            field = (Field)member;
            annotations = field.getDeclaredAnnotations();
        } else if (member instanceof Method) {
            method = (Method)member;
            annotations = method.getDeclaredAnnotations();
        } else {
            throw new IllegalArgumentException("Member must be Field or Method");
        }
        Annotation envAnnotation = this.getEnvAnnotation(annotations);
        if (envAnnotation == null) {
            throw new IllegalArgumentException("No Jakarta EE env dependency annotation found on " + String.valueOf(member));
        }
        String envAnnotationName = null;
        try {
            envAnnotationName = (String)envAnnotation.annotationType().getDeclaredMethod("name", new Class[0]).invoke((Object)envAnnotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid annotation : must have name() attribute " + envAnnotation.toString(), e);
        }
        Object envDependencyName = envAnnotationName;
        Class<?> declaringClass = member.getDeclaringClass();
        if (envAnnotationName == null || envAnnotationName.equals("")) {
            envDependencyName = field != null ? declaringClass.getName() + "/" + field.getName() : declaringClass.getName() + "/" + this.getInjectionMethodPropertyName(method);
        }
        if (envAnnotationName != null && envAnnotationName.startsWith("java:global/")) {
            return this.namingManager.getInitialContext().lookup(envAnnotationName);
        }
        BundleDescriptor matchingBundle = null;
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (bundle instanceof EjbBundleDescriptor || bundle instanceof WebBundleDescriptor) {
                JndiNameEnvironment jndiEnv = (JndiNameEnvironment)bundle;
                for (InjectionCapable next : jndiEnv.getInjectableResourcesByClass(declaringClass.getName())) {
                    if (!next.getComponentEnvName().toString().equals(envDependencyName)) continue;
                    matchingBundle = bundle;
                    break;
                }
            }
            if (matchingBundle == null) continue;
            break;
        }
        if (matchingBundle == null) {
            throw new IllegalArgumentException("Cannot find matching env dependency for " + String.valueOf(member) + " in Application " + app.getAppName());
        }
        String componentId = this.compEnvManager.getComponentEnvId((JndiNameEnvironment)matchingBundle);
        SimpleJndiName lookupName = new SimpleJndiName((String)(((String)envDependencyName).startsWith("java:") ? envDependencyName : "java:comp/env/" + (String)envDependencyName));
        return this.namingManager.lookup(componentId, lookupName);
    }

    private String getInjectionMethodPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.length() <= 3 || !methodName.startsWith("set")) {
            throw new IllegalArgumentException("Illegal env dependency setter name" + method.getName());
        }
        return methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4);
    }

    private Annotation getEnvAnnotation(Annotation[] annotations) {
        Annotation envAnnotation = null;
        for (Annotation next : annotations) {
            String className = next.annotationType().getName();
            if (!className.equals("jakarta.ejb.EJB") && !className.equals("jakarta.annotation.Resource") && !className.equals("jakarta.persistence.PersistenceContext") && !className.equals("jakarta.persistence.PersistenceUnit") && !className.equals("jakarta.xml.ws.WebServiceRef")) continue;
            envAnnotation = next;
            break;
        }
        return envAnnotation;
    }
}

