/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.Collection;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-connector-connection-pool")
@PerLookup
@I18n(value="delete.connector.connection.pool")
public class DeleteConnectorConnectionPool
implements AdminCommand {
    private static final System.Logger LOG = System.getLogger(DeleteConnectorConnectionPool.class.getName());
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(DeleteConnectorConnectionPool.class);
    @Param(optional=true, obsolete=true, defaultValue="server")
    private String target;
    @Param(optional=true, defaultValue="false")
    private Boolean cascade;
    @Param(name="poolname", primary=true)
    private String poolname;
    @Inject
    private Domain domain;
    @Inject
    private IterableProvider<Server> servers;
    @Inject
    private IterableProvider<Cluster> clusters;

    public void execute(AdminCommandContext context) {
        LOG.log(System.Logger.Level.DEBUG, "execute(context={0}); poolname={1}, target={2}", context, this.poolname, this.target);
        ActionReport report = context.getActionReport();
        if (this.poolname == null) {
            report.setMessage(I18N.getLocalString("delete.connector.connection.pool.noJndiName", "No id defined for connector connection pool."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        SimpleJndiName jndiName = new SimpleJndiName(this.poolname);
        if (this.domain.getResources().getResourceByName(ConnectorConnectionPool.class, jndiName) == null) {
            report.setMessage(I18N.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            int obj = this.deleteAssociatedResources((Iterable<Server>)this.servers, (Iterable<Cluster>)this.clusters, this.domain.getResources(), this.cascade, jndiName);
            if (obj == 1) {
                report.setMessage(I18N.getLocalString("delete.connector.connection.pool.pool_in_use", "Some connector resources are referencing connection pool {0}. Use 'cascade' option to delete them as well.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            SingleConfigCode configCode = param -> {
                ConnectorConnectionPool cp = (ConnectorConnectionPool)this.domain.getResources().getResourceByName(ConnectorConnectionPool.class, jndiName);
                if (cp == null) {
                    return null;
                }
                return param.getResources().remove(cp);
            };
            if (ConfigSupport.apply((SingleConfigCode)configCode, (ConfigBeanProxy)this.domain.getResources()) == null) {
                report.setMessage(I18N.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            LOG.log(System.Logger.Level.ERROR, "Something went wrong in delete-connector-connection-pool", (Throwable)tfe);
            report.setMessage(tfe.getMessage() != null ? tfe.getLocalizedMessage() : I18N.getLocalString("delete.connector.connection.pool.fail", "Connector connection pool {0} delete failed ", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(I18N.getLocalString("delete.connector.connection.pool.success", "Connector connection pool {0} deleted successfully", new Object[]{this.poolname}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private int deleteAssociatedResources(Iterable<Server> servers, Iterable<Cluster> clusters, Resources resources, boolean cascade, SimpleJndiName poolName) throws TransactionFailure {
        if (cascade) {
            SingleConfigCode configCode = param -> {
                Collection referringResources = ConnectorsUtil.getResourcesOfPool((Resources)param, (SimpleJndiName)poolName);
                for (BindableResource referringResource : referringResources) {
                    SimpleJndiName jndiName = SimpleJndiName.of((String)referringResource.getJndiName());
                    LOG.log(System.Logger.Level.INFO, "Deleting referring resource: {0}", jndiName);
                    this.deleteServerResourceRefs(servers, jndiName);
                    this.deleteClusterResourceRefs(clusters, jndiName);
                    param.getResources().remove(referringResource);
                }
                return true;
            };
            ConfigSupport.apply((SingleConfigCode)configCode, (ConfigBeanProxy)resources);
        } else {
            Collection referringResources = ConnectorsUtil.getResourcesOfPool((Resources)resources, (SimpleJndiName)poolName);
            if (!referringResources.isEmpty()) {
                return 1;
            }
        }
        return 0;
    }

    private void deleteServerResourceRefs(Iterable<Server> servers, SimpleJndiName refName) throws TransactionFailure {
        if (servers != null) {
            for (Server server : servers) {
                server.deleteResourceRef(refName);
            }
        }
    }

    private void deleteClusterResourceRefs(Iterable<Cluster> clusters, SimpleJndiName refName) throws TransactionFailure {
        if (clusters != null) {
            for (Cluster cluster : clusters) {
                cluster.deleteResourceRef(refName);
            }
        }
    }
}

