/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.acl;

import com.sun.enterprise.security.ee.acl.Resource;

public class WebResource
extends Resource {
    private transient boolean wildcard;
    private transient String path;

    public WebResource(String app, String name, String method) {
        super(app, name, method);
        this.init(name);
    }

    private void init(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (name.endsWith("/*") || name.equals("*")) {
            this.wildcard = true;
            this.path = name.length() == 1 ? "" : name.substring(0, name.length() - 1);
        } else {
            this.path = name;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Resource r = (Resource)obj;
        return this.getApplication().equals(r.getApplication()) && this.getMethod().equals(r.getMethod()) && this.getName().equals(r.getName());
    }

    @Override
    public boolean implies(Resource resource) {
        if (resource == null || resource.getClass() != this.getClass()) {
            return false;
        }
        WebResource that = (WebResource)resource;
        if (!this.getMethod().equals(that.getMethod())) {
            return false;
        }
        if (this.wildcard) {
            if (that.wildcard) {
                return that.path.startsWith(this.path);
            }
            return that.path.length() > this.path.length() && that.path.startsWith(this.path);
        }
        if (that.wildcard) {
            return false;
        }
        return this.path.equals(that.path);
    }
}

