/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationManager;
import org.glassfish.hk2.extras.operation.internal.SingleOperationManager;

@Singleton
public class OperationManagerImpl
implements OperationManager {
    private final ReentrantLock lock = new ReentrantLock();
    private final HashMap<Class<? extends Annotation>, SingleOperationManager<?>> children = new HashMap();
    @Inject
    private ServiceLocator locator;

    @Override
    public <T extends Annotation> OperationHandle<T> createOperation(T scope) {
        SingleOperationManager<Object> manager;
        this.lock.lock();
        try {
            manager = this.children.get(scope.annotationType());
            if (manager == null) {
                manager = new SingleOperationManager<T>(scope, this.locator);
                this.children.put(scope.annotationType(), manager);
            }
        }
        finally {
            this.lock.unlock();
        }
        return manager.createOperation();
    }

    @Override
    public <T extends Annotation> OperationHandle<T> createAndStartOperation(T scope) {
        OperationHandle<T> retVal = this.createOperation(scope);
        retVal.resume();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Annotation> Set<OperationHandle<T>> getCurrentOperations(T scope) {
        SingleOperationManager<?> manager;
        this.lock.lock();
        try {
            manager = this.children.get(scope.annotationType());
            if (manager == null) {
                Set<OperationHandle<T>> set = Collections.emptySet();
                return set;
            }
        }
        finally {
            this.lock.unlock();
        }
        return manager.getAllOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Annotation> OperationHandle<T> getCurrentOperation(T scope) {
        SingleOperationManager<?> manager;
        this.lock.lock();
        try {
            manager = this.children.get(scope.annotationType());
            if (manager == null) {
                OperationHandle<T> operationHandle = null;
                return operationHandle;
            }
        }
        finally {
            this.lock.unlock();
        }
        return manager.getCurrentOperationOnThisThread();
    }

    @Override
    public void shutdownAllOperations(Annotation scope) {
        this.lock.lock();
        try {
            SingleOperationManager<?> manager = this.children.remove(scope.annotationType());
            if (manager == null) {
                return;
            }
            manager.shutdown();
        }
        finally {
            this.lock.unlock();
        }
    }
}

