/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

class ConfigMissingImpl
extends AbstractConfigImpl {
    ConfigMissingImpl(ConfigKeyImpl prefix, ConfigKeyImpl key, ConfigFactory factory, ConfigMapperManager mapperManager) {
        super(Config.Type.MISSING, prefix, key, factory, mapperManager);
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public <T> ConfigValue<T> as(Class<T> type) {
        return ConfigValues.create((Config)this, Optional::empty, (Config aConfig) -> aConfig.as(type));
    }

    @Override
    public <T> ConfigValue<T> as(Function<Config, T> mapper) {
        return ConfigValues.create((Config)this, Optional::empty, (Config aConfig) -> aConfig.as(mapper));
    }

    @Override
    public <T> ConfigValue<T> as(GenericType<T> genericType) {
        return ConfigValues.create((Config)this, Optional::empty, (Config aConfig) -> aConfig.as(genericType));
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Class<T> type) throws ConfigMappingException {
        return ConfigValues.create((Config)this, Optional::empty, (Config aConfig) -> aConfig.asList(type));
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
        return ConfigValues.create((Config)this, Optional::empty, (Config aConfig) -> aConfig.asList(mapper));
    }

    @Override
    public ConfigValue<Map<String, String>> asMap() {
        return ConfigValues.create((Config)this, Optional::empty, Config::asMap);
    }

    @Override
    public Stream<Config> traverse(Predicate<Config> predicate) {
        return Stream.empty();
    }

    public String toString() {
        return "[" + this.realKey() + "] MISSING";
    }
}

