/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.logging.LogDomains;
import jakarta.resource.NotSupportedException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.AuthenticationMechanism;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.Connector;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

@Connector(description={"Resource adapter wrapping implementation of driver"}, displayName={"Resource Adapter"}, vendorName="Sun Microsystems", eisType="Database", version="1.0", authMechanisms={@AuthenticationMechanism(authMechanism="BasicPassword", credentialInterface=AuthenticationMechanism.CredentialInterface.PasswordCredential)})
public class ResourceAdapterImpl
implements ResourceAdapter {
    private static Logger logger = LogDomains.getLogger(ResourceAdapterImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static ResourceAdapterImpl resourceAdapterImpl;
    private BootstrapContext bootstrapContext;
    private Timer timer;

    public ResourceAdapterImpl() {
        if (resourceAdapterImpl == null) {
            resourceAdapterImpl = this;
        }
    }

    public static ResourceAdapterImpl getInstance() {
        if (resourceAdapterImpl == null) {
            throw new IllegalStateException("ResourceAdapter not initialized");
        }
        return resourceAdapterImpl;
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) throws NotSupportedException {
        throw new NotSupportedException("This method is not supported for this JDBC connector");
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws NotSupportedException {
        throw new NotSupportedException("This method is not supported for this JDBC connector");
    }

    public void start(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public void stop() {
        logger.finest("Cancelling the timer");
        if (this.timer != null) {
            this.timer.purge();
            this.timer.cancel();
        }
    }

    public Timer getTimer() {
        if (this.bootstrapContext != null && this.timer == null) {
            logger.finest("Creating the timer");
            try {
                this.timer = this.bootstrapContext.createTimer();
            }
            catch (UnavailableException ex) {
                logger.log(Level.SEVERE, "jdbc-ra.timer_creation_exception", ex.getMessage());
            }
        }
        return this.timer;
    }
}

