/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.InterceptorLogger;
import org.jboss.weld.logging.WeldLogger;

public class InterceptorLogger_$logger
extends DelegatingBasicLogger
implements InterceptorLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InterceptorLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public InterceptorLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void interceptorAnnotationClassNotFound(Object param1) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.interceptorAnnotationClassNotFound$str(), param1);
    }

    protected String interceptorAnnotationClassNotFound$str() {
        return "WELD-001700: Interceptor annotation class {0} not found, interception based on it is not enabled";
    }

    @Override
    public final void invokingNextInterceptorInChain(Object param1) {
        this.log.logv(FQCN, Logger.Level.TRACE, null, this.invokingNextInterceptorInChain$str(), param1);
    }

    protected String invokingNextInterceptorInChain$str() {
        return "WELD-001701: Invoking next interceptor in chain: {0}";
    }

    protected String nullInterceptorBindings$str() {
        return "WELD-001702: Interceptor.getInterceptorBindings() returned null for {0}";
    }

    @Override
    public final DefinitionException nullInterceptorBindings(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.nullInterceptorBindings$str(), param1));
        InterceptorLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void unableToDetermineInterceptedBean(Object injectionPoint) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.unableToDetermineInterceptedBean$str(), injectionPoint);
    }

    protected String unableToDetermineInterceptedBean$str() {
        return "WELD-001703: Unable to determine the @Intercepted Bean<?> for {0}";
    }

    protected String interceptedBeanCanOnlyBeInjectedIntoInterceptor$str() {
        return "WELD-001704: @Intercepted Bean<?> can only be injected into an interceptor: {0}";
    }

    @Override
    public final IllegalArgumentException interceptedBeanCanOnlyBeInjectedIntoInterceptor(Object injectionPoint) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.interceptedBeanCanOnlyBeInjectedIntoInterceptor$str(), injectionPoint));
        InterceptorLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String targetInstanceNotCreated$str() {
        return "WELD-001705: Target instance not created - one of the interceptor methods in the AroundConstruct chain did not invoke InvocationContext.proceed() for: {0}";
    }

    @Override
    public final CreationException targetInstanceNotCreated(Object constructor) {
        CreationException result = new CreationException(this._formatMessage(this.targetInstanceNotCreated$str(), constructor));
        InterceptorLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String interceptionFactoryNotReusable$str() {
        return "WELD-001706: InterceptionFactory.createInterceptedInstance() may only be called once";
    }

    @Override
    public final IllegalStateException interceptionFactoryNotReusable() {
        IllegalStateException result = new IllegalStateException(this.interceptionFactoryNotReusable$str());
        InterceptorLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void interceptionFactoryConfigureInvoked(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.interceptionFactoryConfigureInvoked$str(), param1);
    }

    protected String interceptionFactoryConfigureInvoked$str() {
        return "WELD-001707: InterceptionFactory.configure() was invoked for AnnotatedType: {0}";
    }

    @Override
    public final void interceptionFactoryIgnoreFinalMethodsInvoked(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.interceptionFactoryIgnoreFinalMethodsInvoked$str(), param1);
    }

    protected String interceptionFactoryIgnoreFinalMethodsInvoked$str() {
        return "WELD-001708: InterceptionFactory.ignoreFinalMethods() was invoked for AnnotatedType: {0}. Final methods will be ignored during proxy generation!";
    }

    @Override
    public final void interceptionFactoryNotRequired(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.interceptionFactoryNotRequired$str(), param1);
    }

    protected String interceptionFactoryNotRequired$str() {
        return "WELD-001709: InterceptionFactory skipped wrapper creation for AnnotatedType {0} because no @AroundInvoke interceptor was bound to it.";
    }

    @Override
    public final void interceptionFactoryInternalContainerConstruct(Object type) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.interceptionFactoryInternalContainerConstruct$str(), type);
    }

    protected String interceptionFactoryInternalContainerConstruct$str() {
        return "WELD-001710: InterceptionFactory skipped wrapper creation for an internal container construct of type {0}";
    }

    protected String interceptionFactoryNotOnInstance$str() {
        return "WELD-001711: InterceptionFactory is not supported on interfaces. Check InterceptionFactory<{0}>";
    }

    @Override
    public final IllegalStateException interceptionFactoryNotOnInstance(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.interceptionFactoryNotOnInstance$str(), param1));
        InterceptorLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

