/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=JMSDestinationDefinitionDescriptor.class)
public class JMSDestinationDefinitionDeployer
implements ResourceDeployer<JMSDestinationDefinitionDescriptor> {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    static final String PROPERTY_PREFIX = "org.glassfish.jms-destination.";

    public void deployResource(JMSDestinationDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(JMSDestinationDefinitionDescriptor resource) throws Exception {
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)resource.getResourceType());
        MyJMSDestinationResource jmsDestinationResource = new MyJMSDestinationResource(resource, resourceName);
        this.getDeployer(jmsDestinationResource).deployResource((Object)jmsDestinationResource);
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    private JMSDestinationProperty convertProperty(String name, String value) {
        return new JMSDestinationProperty(this, name, value);
    }

    public void undeployResource(JMSDestinationDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    public void undeployResource(JMSDestinationDefinitionDescriptor resource) throws Exception {
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)resource.getResourceType());
        MyJMSDestinationResource jmsDestinationResource = new MyJMSDestinationResource(resource, resourceName);
        this.getDeployer(jmsDestinationResource).undeployResource((Object)jmsDestinationResource);
    }

    public void enableResource(JMSDestinationDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for jms-destination-definition type");
    }

    public void disableResource(JMSDestinationDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for jms-destination-definition type");
    }

    public boolean handles(Object resource) {
        return resource instanceof JMSDestinationDefinitionDescriptor;
    }

    class MyJMSDestinationResource
    extends FakeConfigBean
    implements AdminObjectResource {
        private final JMSDestinationDefinitionDescriptor desc;
        private final SimpleJndiName name;

        public MyJMSDestinationResource(JMSDestinationDefinitionDescriptor desc, SimpleJndiName name) {
            super(JMSDestinationDefinitionDeployer.this);
            this.desc = desc;
            this.name = name;
        }

        public String getObjectType() {
            return "user";
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.name.toString();
        }

        public String getResAdapter() {
            String resourceAdapter = this.desc.getResourceAdapter();
            if (resourceAdapter != null && !resourceAdapter.equals("")) {
                return resourceAdapter;
            }
            return "jmsra";
        }

        public void setResAdapter(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public String getJndiName() {
            return this.name.toString();
        }

        public void setJndiName(String value) throws PropertyVetoException {
        }

        public String getResType() {
            return this.desc.getInterfaceName();
        }

        public void setResType(String value) throws PropertyVetoException {
        }

        public String getClassName() {
            return this.desc.getClassName();
        }

        public void setClassName(String value) throws PropertyVetoException {
        }

        public String getEnabled() {
            return "true";
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            String destinationName = this.desc.getDestinationName();
            boolean destinationNameSet = false;
            ArrayList<Property> jmsDestinationProperties = new ArrayList<Property>();
            if (destinationName != null && !destinationName.equals("")) {
                JMSDestinationProperty dp = JMSDestinationDefinitionDeployer.this.convertProperty("Name", destinationName);
                jmsDestinationProperties.add(dp);
                destinationNameSet = true;
            }
            Properties p = this.desc.getProperties();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(JMSDestinationDefinitionDeployer.PROPERTY_PREFIX) || key.equalsIgnoreCase("Name") && destinationNameSet) continue;
                String value = (String)entry.getValue();
                JMSDestinationProperty dp = JMSDestinationDefinitionDeployer.this.convertProperty(key, value);
                jmsDestinationProperties.add(dp);
            }
            return jmsDestinationProperties;
        }

        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new JMSDestinationProperty(JMSDestinationDefinitionDeployer.this, name, value);
        }

        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String value = this.desc.getProperty(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }

        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class JMSDestinationProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        JMSDestinationProperty(JMSDestinationDefinitionDeployer this$0, String name, String value) {
            super(this$0);
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean(JMSDestinationDefinitionDeployer this$0) {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

