/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.loader.StandardClassLoader;

public final class ClassLoaderFactory {
    private static final Logger log = LogFacade.getLogger();
    private static int debug = 0;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        return ClassLoaderFactory.createClassLoader(unpacked, packed, null, parent);
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, URL[] urls, ClassLoader parent) throws Exception {
        int i;
        log.log(Level.FINE, "Creating new class loader");
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (unpacked != null) {
            for (i = 0; i < unpacked.length; ++i) {
                File file = unpacked[i];
                if (!file.exists() || !file.canRead()) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Including directory or JAR " + file.getAbsolutePath());
                }
                URL url = new URL("file", null, file.getCanonicalPath() + File.separator);
                set.add(url);
            }
        }
        if (packed != null) {
            for (i = 0; i < packed.length; ++i) {
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase(Locale.ENGLISH);
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Including jar file " + file.getAbsolutePath());
                    }
                    URL url = new URL("file", null, file.getCanonicalPath());
                    set.add(url);
                }
            }
        }
        if (urls != null) {
            for (i = 0; i < urls.length; ++i) {
                set.add(urls[i]);
            }
        }
        URL[] array = set.toArray(new URL[set.size()]);
        ClassLoader parentCL = parent;
        StandardClassLoader classLoader = null;
        classLoader = parentCL == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parentCL);
        classLoader.setDelegate(true);
        return classLoader;
    }
}

