/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.impl.StringSubstitutionProperties;
import java.io.File;
import java.io.IOException;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public class SubstitutionFileUtil {
    private static final System.Logger LOG = System.getLogger(SubstitutionFileUtil.class.getName());
    private static final LocalStringsImpl _strings = new LocalStringsImpl(SubstitutionFileUtil.class);
    private static final String INMEMORY_SUBSTITUTION_FILE_SIZE_IN_KB = "inmemory.substitution.file.size.in.kb";
    private static final int DEFAULT_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_KB = 10240;
    private static int PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES = 0;
    public static final int MAX_COPY_BYTE_COUNT = 67076096;

    public static int getInMemorySubstitutionFileSizeInBytes() {
        if (PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES > 0) {
            return PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES;
        }
        try {
            PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES = Integer.parseInt(StringSubstitutionProperties.getProperty(INMEMORY_SUBSTITUTION_FILE_SIZE_IN_KB)) * 1024;
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.INFO, "In-memory string substitution file size is not deDEBUGd.");
            PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES = 10240;
        }
        return PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES > 0 ? PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES : 10240;
    }

    public static File setupDir(String prefix) throws IOException {
        String extractBase = System.getProperty("user.dir");
        File extractDir = null;
        File extractBaseFile = new File(extractBase);
        if (!extractBaseFile.mkdirs()) {
            LOG.log(System.Logger.Level.WARNING, () -> "Could not create directory " + extractBaseFile.getAbsolutePath());
        }
        if ((extractDir = File.createTempFile(prefix, null, extractBaseFile)).delete() && LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, _strings.get("recreateDirectories", new Object[]{extractDir.getAbsolutePath()}));
        }
        if (!extractDir.mkdirs()) {
            LOG.log(System.Logger.Level.WARNING, "Could not create directory {0}", extractDir.getAbsolutePath());
        }
        return extractDir;
    }

    public static void removeDir(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                SubstitutionFileUtil.removeDir(f);
            }
        }
        if (!file.delete() && LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, _strings.get("failureInFileDeletion", new Object[]{file.getAbsolutePath()}));
        }
    }
}

