/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-domains")
@PerLookup
public final class ListDomainsCommand
extends LocalDomainCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListDomainsCommand.class);
    @Param(name="long", shortName="l", optional=true)
    boolean longOpt;
    @Param(shortName="h", optional=true, defaultValue="true")
    boolean header;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            File domainsDirFile = ListDomainsCommand.ok((String)this.domainDirParam) ? new File(this.domainDirParam) : DomainDirs.getDefaultDomainsDir();
            DomainConfig domainConfig = new DomainConfig(null, domainsDirFile.getAbsolutePath());
            PEDomainsManager manager = new PEDomainsManager();
            String[] domainsList = manager.listDomains(domainConfig);
            this.programOpts.setInteractive(false);
            if (domainsList.length > 0) {
                if (this.longOpt) {
                    String[] headings = new String[]{"DOMAIN", "ADMIN_ENDPOINTS", "RUNNING", "RESTART_REQUIRED"};
                    ColumnFormatter cf = this.header ? new ColumnFormatter(headings) : new ColumnFormatter();
                    for (String dn : domainsList) {
                        DomainInfo di = this.getStatus(dn);
                        cf.addRow(new Object[]{dn, di.getAdminEndpoints(), di.status, di.restartRequired});
                    }
                    logger.info(cf.toString());
                } else {
                    for (String dn : domainsList) {
                        logger.info(this.getStatus((String)dn).statusMsg);
                    }
                }
            } else {
                logger.fine(strings.get("NoDomainsToList"));
            }
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage(), (Throwable)e);
        }
        return 0;
    }

    private DomainInfo getStatus(String domainName) throws CommandException {
        this.setDomainName(domainName);
        this.initDomain();
        DomainInfo info = new DomainInfo();
        info.adminAddr = this.loadAdminAddresses(this.getDomainXml());
        HostAndPort reachableEndpoint = this.getReachableAdminAddress(() -> info.adminAddr);
        if (reachableEndpoint == null) {
            info.status = false;
            info.statusMsg = domainName + " not running";
        } else {
            this.programOpts.setHostAndPort(reachableEndpoint);
            info.status = this.isThisDAS(this.getDomainRootDir());
            info.statusMsg = domainName + " running";
            try {
                RemoteCLICommand cmd = new RemoteCLICommand("_get-restart-required", this.programOpts, this.env);
                String restartRequired = cmd.executeAndReturnOutput(new String[]{"_get-restart-required"});
                info.restartRequired = Boolean.parseBoolean(restartRequired.trim());
                if (info.restartRequired) {
                    info.statusMsg = domainName + " running, restart required to apply configuration changes";
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to check domain status for " + domainName, e);
            }
        }
        return info;
    }

    private static class DomainInfo {
        List<HostAndPort> adminAddr;
        boolean status;
        String statusMsg;
        boolean restartRequired;

        private DomainInfo() {
        }

        private String getAdminEndpoints() {
            return LocalDomainCommand.toHttpList(this.adminAddr);
        }
    }
}

