/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.FastStringWriter;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.FactoryFinder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.servlet.ServletRequest;
import java.io.IOException;
import java.io.Writer;

public final class WidgetUtilities {
    private WidgetUtilities() {
    }

    public static String renderComponent(FacesContext context, UIComponent component) throws IOException {
        if (component == null || !component.isRendered()) {
            return null;
        }
        ResponseWriter oldWriter = context.getResponseWriter();
        Writer strWriter = WidgetUtilities.initStringWriter(context);
        RenderingUtilities.renderComponent(component, context);
        context.setResponseWriter(oldWriter);
        return strWriter.toString();
    }

    private static Writer initStringWriter(FacesContext context) {
        ResponseWriter newWriter;
        if (context == null) {
            return null;
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        ResponseWriter oldWriter = context.getResponseWriter();
        FastStringWriter strWriter = new FastStringWriter(1024);
        if (null != oldWriter) {
            newWriter = oldWriter.cloneWithWriter((Writer)strWriter);
        } else {
            ExternalContext extContext = context.getExternalContext();
            ServletRequest request = (ServletRequest)extContext.getRequest();
            newWriter = renderKit.createResponseWriter((Writer)strWriter, null, request.getCharacterEncoding());
        }
        context.setResponseWriter(newWriter);
        return strWriter;
    }
}

