/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.ClientArtifactsManager;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class ClientJarWriter {
    private static final Logger LOG = DeploymentContextImpl.deplLogger;
    private final ExtendedDeploymentContext deploymentContext;
    private final String name;
    private final Map<URI, JarFile> jarFiles = new HashMap<URI, JarFile>();

    public ClientJarWriter(ExtendedDeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
        this.name = VersioningUtils.getUntaggedName(((DeployCommandParameters)deploymentContext.getCommandParameters(DeployCommandParameters.class)).name());
    }

    public void run() throws IOException {
        if (this.isArtifactsPresent()) {
            LOG.log(Level.FINE, "Skipping possible client JAR generation because it would already have been done");
            return;
        }
        Artifacts downloadableArtifacts = DeploymentUtils.downloadableArtifacts((DeploymentContext)this.deploymentContext);
        Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts((DeploymentContext)this.deploymentContext);
        File clientJarFile = this.createClientJARIfNeeded(this.name);
        if (clientJarFile == null) {
            LOG.log(Level.FINE, "No client JAR generation is needed.");
        } else {
            LOG.log(Level.INFO, "Generated client JAR {0} for possible download of size {1} B", new Object[]{clientJarFile, clientJarFile.length()});
            downloadableArtifacts.addArtifact(clientJarFile.toURI(), clientJarFile.getName());
            generatedArtifacts.addArtifact(clientJarFile.toURI(), clientJarFile.getName());
        }
    }

    private boolean isArtifactsPresent() {
        return this.deploymentContext.getCommandParameters(OpsParams.class).origin.isArtifactsPresent();
    }

    private File createClientJARIfNeeded(String appName) throws IOException {
        File movedPreexistingFile;
        LOG.log(Level.FINEST, "createClientJARIfNeeded(appName={0})", appName);
        ClientArtifactsManager clientArtifactsManager = ClientArtifactsManager.get((DeploymentContext)this.deploymentContext);
        if (clientArtifactsManager.isEmpty()) {
            return null;
        }
        this.deploymentContext.prepareScratchDirs();
        String generatedClientJARName = ClientJarWriter.generatedClientJARNameAndType(appName);
        File generatedClientJARFile = new File(this.deploymentContext.getScratchDir("xml"), generatedClientJARName);
        if (generatedClientJARFile.exists()) {
            try {
                movedPreexistingFile = this.mergeContentsToClientArtifactsManager(generatedClientJARFile, clientArtifactsManager);
                LOG.log(Level.FINEST, "Moved preexisting file: {0}", movedPreexistingFile);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        } else {
            movedPreexistingFile = null;
        }
        ArrayList<Artifacts.FullAndPartURIs> artifacts = new ArrayList<Artifacts.FullAndPartURIs>(clientArtifactsManager.artifacts());
        try {
            File file;
            OutputJarArchive generatedClientJAR = new OutputJarArchive();
            try {
                generatedClientJAR.create(generatedClientJARFile.toURI());
                if (this.isManifestPresent(artifacts)) {
                    LOG.log(Level.FINEST, "The jar file already contains a manifest, no need to generate another.");
                } else {
                    Artifacts.FullAndPartURIs manifest = this.generateManifest();
                    LOG.log(Level.CONFIG, "Generated manifest: {0}", manifest);
                    artifacts.add(manifest);
                }
                this.copyArtifactsToClientJAR(generatedClientJAR, artifacts);
                file = generatedClientJARFile;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        generatedClientJAR.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (!generatedClientJARFile.delete()) {
                        generatedClientJARFile.deleteOnExit();
                    }
                    throw e;
                }
            }
            generatedClientJAR.close();
            return file;
        }
        finally {
            if (movedPreexistingFile != null) {
                FileUtils.deleteFileNowOrLater((File)movedPreexistingFile);
            }
        }
    }

    private File mergeContentsToClientArtifactsManager(File generatedClientJARFile, ClientArtifactsManager clientArtifactsManager) throws IOException, URISyntaxException {
        File movedGeneratedFile = File.createTempFile(generatedClientJARFile.getName(), ".tmp", generatedClientJARFile.getParentFile());
        FileUtils.renameFile((File)generatedClientJARFile, (File)movedGeneratedFile);
        try (InputJarArchive existingGeneratedJAR = new InputJarArchive(movedGeneratedFile);){
            Enumeration<String> e = existingGeneratedJAR.entries();
            while (e.hasMoreElements()) {
                String entryName = e.nextElement();
                URI entryURI = new URI("jar", movedGeneratedFile.toURI().toASCIIString() + "!/" + entryName, null);
                Artifacts.FullAndPartURIs uris = new Artifacts.FullAndPartURIs(entryURI, entryName);
                clientArtifactsManager.add(uris);
            }
            Artifacts.FullAndPartURIs manifestURIs = new Artifacts.FullAndPartURIs(new URI("jar", movedGeneratedFile.toURI().toASCIIString() + "!/META-INF/MANIFEST.MF", null), "META-INF/MANIFEST.MF");
            clientArtifactsManager.add(manifestURIs);
            File file = movedGeneratedFile;
            return file;
        }
    }

    private boolean isManifestPresent(Collection<Artifacts.FullAndPartURIs> artifacts) {
        for (Artifacts.FullAndPartURIs a : artifacts) {
            if (!a.getPart().toASCIIString().equals("META-INF/MANIFEST.MF")) continue;
            return true;
        }
        return false;
    }

    private Artifacts.FullAndPartURIs generateManifest() throws IOException {
        File mfFile = File.createTempFile("clientmf", ".MF");
        try (BufferedOutputStream mfOS = new BufferedOutputStream(new FileOutputStream(mfFile));){
            Manifest mf = new Manifest();
            mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            mf.write(mfOS);
        }
        return new Artifacts.FullAndPartURIs(mfFile.toURI(), "META-INF/MANIFEST.MF", true);
    }

    private static String generatedClientJARNameAndType(String earName) {
        return ClientJarWriter.generatedClientJARPrefix(earName) + ".jar";
    }

    private static String generatedClientJARPrefix(String earName) {
        return earName + "Client";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArtifactsToClientJAR(OutputJarArchive generatedJar, Collection<Artifacts.FullAndPartURIs> artifacts) throws IOException {
        HashSet<String> pathsWrittenToJAR = new HashSet<String>();
        StringBuilder copiedFiles = LOG.isLoggable(Level.CONFIG) ? new StringBuilder() : null;
        for (Artifacts.FullAndPartURIs artifact : artifacts) {
            String artPath = artifact.getPart().getRawPath();
            int previousSlash = artPath.indexOf(47);
            while (previousSlash != -1) {
                String partialAncestorPath = artPath.substring(0, previousSlash + 1);
                if (!pathsWrittenToJAR.contains(partialAncestorPath)) {
                    WritableArchiveEntry entry = generatedJar.putNextEntry(partialAncestorPath);
                    if (entry != null) {
                        entry.close();
                    }
                    pathsWrittenToJAR.add(partialAncestorPath);
                }
                previousSlash = artPath.indexOf(47, previousSlash + 1);
            }
            try {
                WritableArchiveEntry entry = generatedJar.putNextEntry(artifact.getPart().toASCIIString());
                try {
                    InputStream is = this.openInputStream(artifact);
                    try {
                        FileUtils.copy((InputStream)is, (OutputStream)entry);
                        if (copiedFiles == null) continue;
                        copiedFiles.append(System.lineSeparator()).append("  ").append(artifact.getFull().toASCIIString()).append(" -> ").append(artifact.getPart().toASCIIString());
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                finally {
                    if (entry == null) continue;
                    entry.close();
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not copy the entry " + String.valueOf(artifact.getPart()), e);
            }
            finally {
                File artifactFile;
                if (!artifact.isTemporary() || (artifactFile = new File(artifact.getFull())).delete()) continue;
                artifactFile.deleteOnExit();
            }
        }
        if (copiedFiles != null) {
            LOG.log(Level.CONFIG, "Copied files: {0}", copiedFiles);
        }
    }

    private InputStream openInputStream(Artifacts.FullAndPartURIs artifact) throws URISyntaxException, IOException {
        LOG.log(Level.FINE, "openInputStream(artifact={0})", artifact);
        URI fullURI = artifact.getFull();
        String scheme = fullURI.getScheme();
        if (scheme.equals("file")) {
            return new FileInputStream(new File(fullURI));
        }
        if (scheme.equals("jar")) {
            String ssp = fullURI.getSchemeSpecificPart();
            URI jarURI = new URI(ssp.substring(0, ssp.indexOf("!/")));
            JarFile jf = this.jarFiles.get(jarURI);
            if (jf == null) {
                jf = new JarFile(new File(jarURI));
                this.jarFiles.put(jarURI, jf);
            }
            String entryName = ssp.substring(ssp.indexOf("!/") + 2);
            JarEntry jarEntry = jf.getJarEntry(entryName);
            return jf.getInputStream(jarEntry);
        }
        throw new IllegalArgumentException(scheme + " != [file,jar]");
    }
}

