/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.shared.common.error.StandardException;

public class RoutinePrivilegeInfo
extends PrivilegeInfo {
    private AliasDescriptor aliasDescriptor;

    public RoutinePrivilegeInfo(AliasDescriptor aliasDescriptor) {
        this.aliasDescriptor = aliasDescriptor;
    }

    @Override
    public void executeGrantRevoke(Activation activation, boolean bl, List list) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string = languageConnectionContext.getCurrentUserId(activation);
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.checkOwnership(string, this.aliasDescriptor, dataDictionary.getSchemaDescriptor(this.aliasDescriptor.getSchemaUUID(), transactionController), dataDictionary);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        RoutinePermsDescriptor routinePermsDescriptor = dataDescriptorGenerator.newRoutinePermsDescriptor(this.aliasDescriptor, string);
        dataDictionary.startWriting(languageConnectionContext);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = false;
            String string2 = (String)iterator.next();
            if (dataDictionary.addRemovePermissionsDescriptor(bl, routinePermsDescriptor, string2, transactionController)) {
                bl2 = true;
                dataDictionary.getDependencyManager().invalidateFor(routinePermsDescriptor, 45, languageConnectionContext);
                dataDictionary.getDependencyManager().invalidateFor(this.aliasDescriptor, 23, languageConnectionContext);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, bl, bl2, string2);
        }
    }
}

