/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.cdi;

import ee.jakarta.tck.persistence.ee.cdi.CtsEmQualifier;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.persistence.Cache;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.SchemaManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.util.logging.Level;
import java.util.logging.Logger;

@RequestScoped
public class TestBeanUtilities {
    Logger logger = Logger.getLogger(TestBeanUtilities.class.getName());
    @Inject
    @CtsEmQualifier
    private CriteriaBuilder criteriaBuilder;
    @Inject
    @CtsEmQualifier
    private PersistenceUnitUtil persistenceUnitUtil;
    @Inject
    @CtsEmQualifier
    private Cache cache;
    @Inject
    @CtsEmQualifier
    private Metamodel metamodel;
    @Inject
    @CtsEmQualifier
    private SchemaManager schemaManager;

    public void logMsg(String msg) {
        this.logger.info(msg);
    }

    public void logTrace(String msg) {
        this.logger.fine(msg);
    }

    public void logErr(String msg) {
        this.logger.severe(msg);
    }

    public void logErr(String msg, Throwable e) {
        this.logger.log(Level.SEVERE, msg, e);
    }

    public void injectUtilitiesUsingQualifier() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            this.logMsg("Test @CtsEmQualifier");
            if (this.criteriaBuilder != null) {
                this.logTrace("Received non-null criteriaBuilder");
                pass1 = true;
            } else {
                this.logErr("Received null criteriaBuilder");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test @CtsEmQualifier");
            if (this.persistenceUnitUtil != null) {
                this.logTrace("Received non-null persistenceUnitUtil");
                pass2 = true;
            } else {
                this.logErr("Received null persistenceUnitUtil");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test @CtsEmQualifier");
            if (this.cache != null) {
                this.logTrace("Received non-null cache");
                pass3 = true;
            } else {
                this.logErr("Received null cache");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test @CtsEmQualifier");
            if (this.metamodel != null) {
                this.logTrace("Received non-null metamodel");
                pass4 = true;
            } else {
                this.logErr("Received null metamodel");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test @CtsEmQualifier");
            if (this.schemaManager != null) {
                this.logTrace("Received non-null schemaManager");
                pass5 = true;
            } else {
                this.logErr("Received null schemaManager");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("injection failed");
        }
        this.logMsg("Test PASSED");
    }
}

