/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.packaging.ejb.standalone;

import ee.jakarta.tck.persistence.ee.packaging.ejb.standalone.Stateful3IF;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

@Dependent
public class Client {
    private static Logger log = Logger.getLogger(Client.class.getName());
    @Dependent
    @Inject
    Instance<Stateful3IF> statefulBeanInstance;
    Stateful3IF statefulBean;
    private Properties props;

    @PostConstruct
    public void setup() {
        try {
            this.cleanup();
        }
        catch (Exception e) {
            throw new IllegalStateException("Setup Failed!", e);
        }
    }

    @Test
    public void test1() throws Exception {
        log.info("Begin test1");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            pass = this.statefulBean.test1();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.statefulBean != null) {
                this.statefulBean.removeTestData();
                this.statefulBeanInstance.destroy((Object)this.statefulBean);
                this.statefulBean = null;
            }
        }
        catch (Exception re) {
            log.log(Level.WARNING, "Unexpected Exception in entity cleanup:", re);
        }
        log.info("cleanup complete");
    }
}

