/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.transactional;

import com.sun.ts.tests.jta.ee.transactional.CTSDontRollbackException;
import com.sun.ts.tests.jta.ee.transactional.CTSRollbackException;
import com.sun.ts.tests.jta.ee.transactional.OneManagedQualifier;
import jakarta.annotation.Priority;
import jakarta.annotation.Resource;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@OneManagedQualifier
public class OneManagedBean {
    public static final String NAME = "one-managed-bean";
    @Resource(lookup="java:comp/UserTransaction")
    private UserTransaction ut2;
    @Inject
    BeanManager beanManager;
    String myString;

    private void setMyString(String s) {
        this.myString = s;
    }

    public String getName() {
        return NAME;
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public String txTypeRequired() {
        String result = "txTypeRequired called successfully";
        return result;
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public String txTypeRequiredIllegalStateException() {
        Object result = "not received IllegalStateException";
        try {
            this.ut2.begin();
            String var = "do nothing";
            this.ut2.commit();
        }
        catch (IllegalStateException ise) {
            result = "IllegalStateException";
            this.setMyString((String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "unexcepted Exception :" + e.getMessage();
            this.setMyString((String)result);
        }
        return result;
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public String txTypeRequiresNew() {
        String result = "txTypeRequiresNew called successfully";
        return result;
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public String txTypeMandatory() {
        String result = "txTypeMandatory called successfully";
        return result;
    }

    @Transactional(value=Transactional.TxType.SUPPORTS)
    public String txTypeSupports() {
        String result = "txTypeSupports called successfully";
        return result;
    }

    @Transactional(value=Transactional.TxType.SUPPORTS)
    public String txTypeSupportsWithoutTransaction() {
        String result = "txTypeSupports run without active transaction";
        return result;
    }

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public String txTypeNotSupported() {
        String result = "txTypeNotSupported run without active transaction";
        return result;
    }

    @Transactional(value=Transactional.TxType.NEVER)
    public String txTypeNever() {
        String result = "txTypeNever run without active transaction";
        return result;
    }

    @Transactional(rollbackOn={CTSRollbackException.class})
    public void rollbackOnException() throws CTSRollbackException {
        throw new CTSRollbackException("CTSRollbackException");
    }

    @Transactional(dontRollbackOn={CTSDontRollbackException.class})
    public void dontRollbackOnException() throws CTSDontRollbackException {
        throw new CTSDontRollbackException("CTSDontRollbackException");
    }

    @Transactional(rollbackOn={CTSRollbackException.class}, dontRollbackOn={CTSRollbackException.class})
    public void rollbackAndDontRollback() throws CTSRollbackException {
        throw new CTSRollbackException("CTSRollbackException");
    }

    public List<Integer> getPriority(String methodName) {
        int priorityValue = 0;
        ArrayList<Integer> priorityList = new ArrayList<Integer>();
        try {
            Class<?> bClass = this.getClass();
            Method m = bClass.getMethod(methodName, new Class[0]);
            Annotation[] annotationArray = m.getAnnotations();
            List interceptorList = this.beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, annotationArray);
            for (Interceptor interceptor : interceptorList) {
                System.out.println("Interceptor Name = " + interceptor.getName());
                System.out.println("Interceptor toString = " + interceptor.toString());
                System.out.println("Interceptor Beanclass = " + interceptor.getBeanClass().getName());
                Priority annotation = interceptor.getBeanClass().getAnnotation(Priority.class);
                if (annotation != null && annotation instanceof Priority) {
                    Priority myPriorityAnnotation = annotation;
                    priorityValue = myPriorityAnnotation.value();
                    System.out.println("Priority value(From Interceptor bean class) = " + priorityValue);
                    priorityList.add(priorityValue);
                } else {
                    Set annotations = interceptor.getInterceptorBindings();
                    System.out.println("InterceptorBindings set size =" + annotations.size());
                    for (Annotation ibAnnotation : annotations) {
                        System.out.println("InterceptorBindings Annototation : " + ibAnnotation.getClass().getName());
                        System.out.println("InterceptorBindings Annototation type : " + String.valueOf(ibAnnotation.annotationType()));
                        if (ibAnnotation == null || !(ibAnnotation instanceof Priority)) continue;
                        Priority myPriorityAnnotation = (Priority)ibAnnotation;
                        priorityValue = myPriorityAnnotation.value();
                        System.out.println("Priority value(From Interceptor bindings) = " + priorityValue);
                        priorityList.add(priorityValue);
                    }
                }
                if (priorityValue != 0) continue;
                System.out.println("Priority Annotation not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return priorityList;
    }
}

