/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.interceptors;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import org.jboss.cdi.tck.tests.extensions.interceptors.FullMarathon;
import org.jboss.cdi.tck.tests.extensions.interceptors.Marathon;

@FullMarathon
@Interceptor
public class LifecycleInterceptor {
    private static boolean preDestroyCalled = false;
    private static boolean postConstructCalled = false;

    @PreDestroy
    public void preDestroy(InvocationContext ctx) {
        preDestroyCalled = true;
    }

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        Object marathon = ctx.getTarget();
        if (marathon instanceof Marathon) {
            Marathon m = (Marathon)marathon;
            m.setLength(42L);
        }
        postConstructCalled = true;
    }

    public static boolean isPostConstructCalled() {
        return postConstructCalled;
    }

    public static boolean isPreDestroyCalled() {
        return preDestroyCalled;
    }
}

