/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.session.jspejbjdbc;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.integration.session.jspejbjdbc.Teller;
import java.util.Properties;

public class AccessJSPBean {
    private static final int ACCOUNT = 1075;
    private static final String TELLERNAME = "joe";
    private static final String ejbRef = "java:comp/env/ejb/TellerBean";
    private Teller beanRef = null;
    private TSNamingContext nctx = new TSNamingContext();

    public AccessJSPBean() throws Exception {
        this.beanRef = (Teller)this.nctx.lookup(ejbRef, Teller.class);
    }

    public void setup(Properties p) {
        TestUtil.logTrace((String)"setup");
        try {
            if (p != null) {
                TestUtil.init((Properties)p);
            }
            this.beanRef.initialize(TELLERNAME, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("AccessJSPBean: Exception occurred - " + String.valueOf(e)), (Throwable)e);
        }
    }

    public String getMsg() {
        try {
            if (this.beanRef == null) {
                return "could not talk to the EJB in method getMsg -> java:comp/env/ejb/TellerBean";
            }
            return this.beanRef.sayHello();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return "Got Exception : " + e.getMessage();
        }
    }

    public Properties getTransactionProps() {
        TestUtil.logTrace((String)"getTransactionProps");
        Properties p = new Properties();
        try {
            if (this.beanRef == null) {
                return p;
            }
            TestUtil.logTrace((String)"Perform database transactions");
            double balance = this.beanRef.balance(1075);
            p.setProperty("Balance", "" + balance);
            TestUtil.logTrace((String)("Balance is " + balance));
            balance = this.beanRef.deposit(1075, 100.0);
            p.setProperty("Deposit", "" + balance);
            TestUtil.logTrace((String)("Deposit 100, balance is " + balance));
            balance = this.beanRef.withdraw(1075, 50.0);
            p.setProperty("Withdraw", "" + balance);
            TestUtil.logTrace((String)("Withdraw 50, balance is " + balance));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + String.valueOf(e)), (Throwable)e);
        }
        return p;
    }
}

