/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.Join;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Order_;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Client2
extends Util {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupOrderData")
    public void joinStringTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = true;
        boolean pass4 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Set sJoins = customer.getJoins();
            if (!sJoins.isEmpty()) {
                this.logErr("Expected getJoins() to return empty set instead got:");
                for (Join j : sJoins) {
                    this.logErr("join:" + j.toString());
                }
            } else {
                this.logTrace("getJoin() returned empty set as expected");
                pass1 = true;
            }
            CollectionJoin order = customer.join(Customer_.orders);
            Set s = customer.getJoins();
            if (s.isEmpty()) {
                this.logErr("Expected getJoins() to return non empty set");
            } else if (s.size() == 1) {
                this.logTrace("getJoins returned:");
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    pass2 = true;
                    Join j = (Join)i.next();
                    this.logTrace("join:" + j.toString());
                    String name = j.getAttribute().getName();
                    if (name.equals("orders")) {
                        this.logTrace("Received expected attribute: orders");
                        continue;
                    }
                    this.logErr("Expected attribute: orders, actual:" + name);
                    pass3 = false;
                }
            } else {
                pass3 = false;
                this.logErr("Expected getJoins to return 1 join, actual:" + s.size());
                this.logErr("getJoins returned:");
                for (Join j : s) {
                    this.logErr("join:" + j.toString());
                }
            }
            Join lineItem = order.join("lineItemsCollection");
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass4 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("joinStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Join lineItem = order.join("lineItemsCollection", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSingularAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Join creditCard = order.join("creditCard");
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)creditCard.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSingularAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSingularAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Join creditCard = order.join("creditCard", JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)creditCard.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSingularAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionAttributeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection);
            CollectionAttribute pa = lineItem.getModel();
            String name = pa.getName();
            if (name.equals("lineItemsCollection")) {
                this.logTrace("Received expected attribute:" + name);
                pass1 = true;
            } else {
                this.logErr("getModel - Expected: lineItemsCollection, actual:" + name);
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinCollectionAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinCollectionAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionStringTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection");
            String name = lineItem.getModel().getName();
            if (name.equals("lineItemsCollection")) {
                this.logTrace("Received expected CollectionAttribute:" + name);
            } else {
                this.logErr("Expected CollectionAttribute:lineItems, actual:" + name);
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinCollectionStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinCollectionStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.join(Order_.lineItemsSet);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSetAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.join(Order_.lineItemsSet, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSetAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetStringTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.joinSet("lineItemsSet");
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSetStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.joinSet("lineItemsSet", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSetStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            ListJoin lineItem = order.joinList("lineItemsList");
            ListAttribute pa = lineItem.getModel();
            String name = pa.getName();
            if (name.equals("lineItemsList")) {
                this.logTrace("Received expected attribute:" + name);
            } else {
                this.logErr("getModel - Expected: lineItemsList, actual:" + name);
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinListAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinListAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListStringTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.joinList("orders3");
            ListJoin lineItem = order.joinList("lineItemsList");
            String name = lineItem.getModel().getName();
            if (name.equals("lineItemsList")) {
                this.logTrace("Received expected ListAttribute:" + name);
                pass1 = true;
            } else {
                this.logErr("Expected ListAttribute:lineItemsList, actual:" + name);
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinListStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.joinList("orders3");
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinListStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pluralJoinTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection");
            String name = lineItem.getModel().getName();
            if (name.equals("lineItemsCollection")) {
                this.logTrace("Received expected PluralAttribute:" + name);
                pass1 = true;
            } else {
                this.logErr("Expected PluralAttribute:lineItems, actual:" + name);
            }
            name = lineItem.getAttribute().getName();
            if (name.equals("lineItemsCollection")) {
                this.logTrace("Received expected attribute:" + name);
                pass2 = true;
            } else {
                this.logErr("Expected attribute name: lineItems, actual:" + name);
            }
            JoinType type = lineItem.getJoinType();
            if (type.equals((Object)JoinType.INNER)) {
                this.logTrace("Received expected JoinType:" + String.valueOf(type));
                pass3 = true;
            } else {
                this.logErr("Expected JoinType : " + JoinType.INNER.toString() + ", actual:" + String.valueOf(type));
            }
            From from = lineItem.getParent();
            String parent = from.getJavaType().getName();
            if (parent.equals("ee.jakarta.tck.persistence.common.schema30.Order")) {
                this.logTrace("Received expected parent:" + parent);
                pass4 = true;
            } else {
                this.logErr("Expected parent: ee.jakarta.tck.persistence.common.schema30.Order, actual:" + parent);
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass5 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("pluralJoinTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pluralJoinOnExpressionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            if (order.getOn() == null) {
                this.logTrace("Received expected null from getOn()");
                pass1 = true;
            } else {
                this.logErr("Expected null from getOn(), actual:" + order.toString());
            }
            Join join = order.on((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1"));
            Predicate pred = join.getOn();
            if (pred != null) {
                this.logTrace("Received expected non-null from getOn()");
                pass2 = true;
            } else {
                this.logErr("Received unexpected null from getOn()");
            }
            cquery.select((Selection)cbuilder.count((Expression)join));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Long actual = (Long)tquery.getSingleResult();
            if (actual == 1L) {
                this.logTrace("Received expected number: " + actual);
                pass3 = true;
            } else {
                this.logErr("Expected: 1, actual:" + actual);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("pluralJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pluralJoinOnPredicateArrayTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Predicate pred1 = cbuilder.equal((Expression)customer.get("id"), (Object)"1");
            Predicate pred2 = cbuilder.equal((Expression)customer.get("country").get("code"), (Object)"USA");
            Predicate[] pred = new Predicate[]{pred1, pred2};
            Join join = order.on(pred);
            Predicate pred3 = join.getOn();
            if (pred3.getExpressions().size() == 2) {
                this.logTrace("Received expected number of predicates");
                pass1 = true;
            } else {
                this.logErr("Expected: 2 predicates, actual:" + pred3.getExpressions().size());
            }
            cquery.select((Selection)cbuilder.count((Expression)join));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Long actual = (Long)tquery.getSingleResult();
            if (actual == 1L) {
                this.logTrace("Received expected number: " + actual);
                pass2 = true;
            } else {
                this.logErr("Expected: 1, actual:" + actual);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("pluralJoinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void collectionJoinOnExpressionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection", JoinType.INNER);
            Predicate exp = cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5);
            lineItem.on((Expression)exp);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("collectionJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void collectionJoinOnPredicateArrayTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection", JoinType.INNER);
            Predicate[] pred = new Predicate[]{cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5), cbuilder.lt((Expression)lineItem.get("quantity"), (Number)8)};
            lineItem.on(pred);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("collectionJoinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void listJoinOnExpressionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            Predicate exp = cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5);
            lineItem.on((Expression)exp);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("listJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void listJoinOnPredicateArrayTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            Predicate[] pred = new Predicate[]{cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5), cbuilder.lt((Expression)lineItem.get("quantity"), (Number)8)};
            lineItem.on(pred);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("listJoinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void setJoinOnExpressionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            SetJoin lineItem = order.joinSet("lineItemsSet", JoinType.INNER);
            Predicate exp = cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5);
            lineItem.on((Expression)exp);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("setJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void setJoinOnPredicateArrayTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            SetJoin lineItem = order.joinSet("lineItemsSet", JoinType.INNER);
            Predicate[] pred = new Predicate[]{cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5), cbuilder.lt((Expression)lineItem.get("quantity"), (Number)8)};
            lineItem.on(pred);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("setJoinOnPredicateArrayTest failed");
        }
    }
}

