/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.xa.ee.resXcomp2;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.xa.ee.resXcomp2.Ejb2Test;
import jakarta.ejb.EJBException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;

public class Ejb1TestEJB {
    private Properties p = null;
    private Properties testProps = null;
    private Ejb2Test ref = null;
    private TSNamingContext context = null;
    private DataSource ds1 = null;
    private String dbTable1 = null;
    private transient Connection con1 = null;
    private transient Statement stmt;
    private TSEISDataSource ds2;
    private transient TSConnection con2 = null;

    public void initialize(Properties props) {
        this.testProps = props;
        String eMsg = "";
        try {
            TestUtil.init((Properties)props);
            this.context = new TSNamingContext();
            eMsg = "Exception doing a lookup for Ejb2Test ";
            this.ref = (Ejb2Test)this.context.lookup("java:comp/env/ejb/Ejb2Test", Ejb2Test.class);
            this.ref.initialize(props);
            TestUtil.logMsg((String)"Initialize logging data from server in Ejb1");
            eMsg = "Exception doing a initLogging for Ejb2Test ";
            this.ref.initLogging(this.p);
            eMsg = "Exception looking up JDBCwhitebox";
            this.ds1 = (DataSource)this.context.lookup("java:comp/env/eis/JDBCwhitebox-tx");
            eMsg = "Exception looking up EIS whitebox";
            this.ds2 = (TSEISDataSource)this.context.lookup("java:comp/env/eis/whitebox-tx");
            TestUtil.logMsg((String)("ds1 : " + String.valueOf(this.ds1)));
            TestUtil.logMsg((String)("ds2 : " + String.valueOf(this.ds2)));
        }
        catch (Exception e) {
            TestUtil.logTrace((String)eMsg);
            TestUtil.logErr((String)"Ejb1: ejbCreate failed", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void dbConnect(String tName) {
        TestUtil.logTrace((String)"dbConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.conTable1();
                TestUtil.logMsg((String)("Made the JDBC connection to " + this.dbTable1 + " DB"));
            } else {
                this.conTable2();
                TestUtil.logMsg((String)"Made the connection to EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception on JDBC connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void insert(String tName) {
        String key = null;
        TestUtil.logTrace((String)"insert");
        try {
            if (tName.equals(this.dbTable1)) {
                TestUtil.logMsg((String)("Insert row in " + this.dbTable1));
                key = new String(this.testProps.getProperty("Xa_Tab1_insert_init"));
                this.stmt = this.con1.createStatement();
                this.stmt.executeUpdate(key);
                TestUtil.logTrace((String)("Inserted a row into the table " + tName));
                TestUtil.logMsg((String)"Calling insert in Ejb2 ");
                this.ref.dbConnect(tName);
                this.ref.insert(tName);
                this.ref.dbUnConnect(tName);
            } else {
                TestUtil.logMsg((String)"Insert row in EIS");
                key = new String(this.testProps.getProperty("TSEIS_insert_init"));
                this.con2.insert(key, key);
                TestUtil.logTrace((String)"Inserted a row into the EIS ");
                TestUtil.logMsg((String)"Calling insert in Ejb2 ");
                this.ref.dbConnect("EIS");
                this.ref.insert("EIS");
                this.ref.dbUnConnect("EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception inserting a row into table " + tName + ";\n" + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void destroyData(String tName) {
        TestUtil.logTrace((String)"destroyData");
        try {
            if (tName.equals(this.dbTable1)) {
                this.dropTable1();
                TestUtil.logMsg((String)("Deleted all rows from table " + this.dbTable1));
            } else {
                this.dropTable2();
                TestUtil.logMsg((String)"Deleted all rows from EIS ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void dbUnConnect(String tName) {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.con1.close();
                this.con1 = null;
                TestUtil.logTrace((String)("Closed " + this.dbTable1 + " connection"));
            } else {
                this.con2.close();
                this.con2 = null;
                TestUtil.logTrace((String)"Closed EIS connection");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to close the DB connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging Ejb1");
        this.testProps = p;
        try {
            TestUtil.init((Properties)p);
            this.dbTable1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"Xa_Tab1_Delete"));
            TestUtil.logMsg((String)(this.dbTable1 + " Ejb1 initLogging OK!"));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Inside Ejb1 initLogging" + e.getMessage());
        }
    }

    public boolean verifyData(String operation, String tName, int[] expResults) {
        boolean status = false;
        int linenum = 0;
        Statement queryStatement = null;
        ResultSet theResults = null;
        Vector queryResults = new Vector();
        try {
            if (operation.equals("commit")) {
                TestUtil.logMsg((String)("Expected number of rows is: " + expResults.length));
                if (tName.equals(this.dbTable1)) {
                    String query = this.testProps.getProperty("Xa_Tab1_query");
                    TestUtil.logMsg((String)("query is " + query));
                    queryStatement = this.con1.prepareStatement(query);
                    theResults = queryStatement.executeQuery();
                    ResultSetMetaData rsmeta = theResults.getMetaData();
                    int numColumns = rsmeta.getColumnCount();
                    TestUtil.logTrace((String)("Number of columns from rsmeta " + numColumns));
                    while (theResults.next()) {
                        TestUtil.logMsg((String)("Line No: " + ++linenum + " results: " + theResults.getInt(1) + " expResults: " + expResults[linenum - 1]));
                        if (theResults.getInt(1) == expResults[linenum - 1]) {
                            status = true;
                            TestUtil.logTrace((String)("verifyData OK, Status is : " + status));
                            continue;
                        }
                        status = false;
                        TestUtil.logTrace((String)("verifyData ERROR, Status is : " + status));
                        break;
                    }
                    if (expResults.length != linenum) {
                        TestUtil.logTrace((String)"Error - expected row count does not match table in verifyData!!");
                        status = false;
                    }
                } else {
                    int i;
                    queryResults = this.con2.readData();
                    TestUtil.logMsg((String)("Expected number of rows in result: " + expResults.length));
                    for (i = 0; i < expResults.length; ++i) {
                        if (!queryResults.contains(new Integer(expResults[i]).toString())) {
                            status = false;
                            TestUtil.logTrace((String)("VerifyData Error, Status is : " + status));
                            break;
                        }
                        status = true;
                        TestUtil.logTrace((String)("VerifyData OK, Status is : " + status));
                    }
                    for (i = 0; i < queryResults.size(); ++i) {
                        TestUtil.logMsg((String)("Query Results contains : " + String.valueOf(queryResults.elementAt(i))));
                    }
                }
            } else if (tName.equals(this.dbTable1)) {
                String query = this.testProps.getProperty("Xa_Tab1_query");
                TestUtil.logMsg((String)("query is " + query));
                queryStatement = this.con1.prepareStatement(query);
                theResults = queryStatement.executeQuery();
                TestUtil.logTrace((String)("status is " + status));
                status = !theResults.next();
                TestUtil.logMsg((String)("Resultset has no data? " + status));
            } else {
                int i;
                queryResults = this.con2.readData();
                for (i = 0; i < expResults.length; ++i) {
                    TestUtil.logMsg((String)("Not Expected results: " + expResults[i]));
                    if (queryResults.contains(new Integer(expResults[i]).toString())) {
                        status = false;
                        TestUtil.logTrace((String)("VerifyData Error, Status is : " + status));
                        break;
                    }
                    status = true;
                    TestUtil.logTrace((String)("VerifyData OK, Status is : " + status));
                }
                for (i = 0; i < queryResults.size(); ++i) {
                    TestUtil.logMsg((String)("Query Results contains : " + String.valueOf(queryResults.elementAt(i))));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Error verifyData database inserts Ejb1 ");
            TestUtil.printStackTrace((Throwable)e);
            status = false;
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (theResults != null) {
                    theResults.close();
                }
                if (queryStatement != null) {
                    queryStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        TestUtil.logTrace((String)("Verify Data Status is : " + status));
        return status;
    }

    public void throwEJBException() throws EJBException {
        TestUtil.logTrace((String)"throwEJBException");
        throw new EJBException("EJBException from Ejb1TestEJB");
    }

    private void conTable1() {
        TestUtil.logTrace((String)"conTable1");
        try {
            this.con1 = this.ds1.getConnection();
            TestUtil.logTrace((String)("con1: " + this.con1.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.dbTable1 + " DB"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.dbTable1 + " DB"), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable2() {
        TestUtil.logTrace((String)"conTable2");
        try {
            this.con2 = this.ds2.getConnection();
            TestUtil.logTrace((String)("con2: " + this.con2.toString()));
        }
        catch (Exception ee) {
            TestUtil.logErr((String)"Exception connecting to EIS ", (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void dropTable1() {
        TestUtil.logTrace((String)"dropTable1");
        String removeString = TestUtil.getProperty((String)"Xa_Tab1_Delete");
        try {
            this.stmt = this.con1.createStatement();
            this.stmt.executeUpdate(removeString);
            this.stmt.close();
        }
        catch (SQLException e) {
            throw new EJBException(e.getMessage());
        }
    }

    private void dropTable2() {
        TestUtil.logTrace((String)"dropTable2");
        try {
            this.con2.dropTable();
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
    }
}

