/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.web;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.common.InnerClassFilenameFilter;
import com.sun.ant.taskdefs.common.Packager;
import com.sun.ant.taskdefs.common.SunRITool;
import com.sun.ant.taskdefs.web.WebDescriptorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebTool
extends SunRITool {
    private String ejbJarSuffix = "_web.war";
    private static File webEmpty;
    private String descriptorXmlFileName = "";
    private String descriptorRuntimeXmlFileName = "";
    private Hashtable webClasses;

    public WebTool() {
        if (webEmpty == null) {
            webEmpty = new File(TSBuildListener.tsHome, "src/web/empty");
        }
    }

    protected WebDescriptorHandler getWebDescriptorHandler(File srcDir) {
        this.handler = new WebDescriptorHandler(this.task, srcDir);
        this.registerKnownDTDs(this.handler);
        for (Packager.DTDLocation dtdLocation : this.getConfig().dtdLocations) {
            this.handler.registerDTD(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        return (WebDescriptorHandler)this.handler;
    }

    protected void registerKnownDTDs(WebDescriptorHandler handler) {
        handler.registerDTD(PUBLICID_WEB, TSBuildListener.getDtdDir(this.getTask().getProject()) + File.separator + DEFAULT_SUNRI13_WEB_DTD_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseServletClass(String descriptorFileName, SAXParser saxParser) throws IOException, SAXException {
        FileInputStream descriptorStream = null;
        try {
            descriptorStream = new FileInputStream(new File(this.config.descriptorDir, descriptorFileName));
            saxParser.parse(new InputSource(descriptorStream), (HandlerBase)this.handler);
            this.webClasses = ((WebDescriptorHandler)this.handler).getClasses();
        }
        finally {
            if (descriptorStream != null) {
                try {
                    descriptorStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void processDescriptor(String descriptorFileName, SAXParser saxParser) {
        String baseName = this.config.name + "_web";
        String jarFileName = baseName + ".war";
        if (descriptorFileName.indexOf(".xml") < 0) {
            this.descriptorXmlFileName = this.config.name + "_web.xml";
            this.descriptorRuntimeXmlFileName = this.config.name + "_web.runtime.xml";
        } else {
            this.descriptorXmlFileName = descriptorFileName;
        }
        this.checkConfiguration(this.descriptorXmlFileName, saxParser);
        try {
            this.handler = this.getWebDescriptorHandler(this.config.srcDir);
            Hashtable webFiles = new Hashtable();
            this.addContentFiles(webFiles);
            this.parseServletClass(this.descriptorXmlFileName, saxParser);
            this.autoCheckExclude(this.webClasses);
            this.addSupportClasses(this.webClasses);
            this.checkAndAddInherited(this.webClasses);
            File jarFile = new File(this.destDir, jarFileName);
            if (this.needToRebuild(webFiles, jarFile) || this.needToRebuild(this.webClasses, jarFile)) {
                this.log("building " + jarFile.getPath() + " with " + String.valueOf(webFiles.size()) + " content files and " + String.valueOf(this.webClasses.size()) + " class files", 3);
                String publicId = this.handler.getPublicId();
                this.writeWar(baseName, jarFile, webFiles, this.webClasses, publicId);
            } else {
                this.log(jarFile.toString() + " is up to date.", 3);
            }
        }
        catch (Exception e) {
            this.log(e.getMessage(), 2);
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeWar(String baseName, File jarfile, Hashtable files, Hashtable classes, String publicId) throws BuildException {
        File entryFile;
        String sFilesToAdd = "";
        String sClassesToAdd = "";
        String sJarFilesToAdd = "";
        boolean hasContentFiles = true;
        String sJarFile = jarfile.getPath();
        if (jarfile.exists()) {
            jarfile.delete();
        }
        for (String entryName : files.keySet()) {
            entryFile = (File)files.get(entryName);
            this.log("adding web file '" + entryName + "'", 3);
            if (entryName.charAt(0) == '/') {
                entryName = entryName.substring(1);
            }
            if (!sFilesToAdd.equals("")) {
                sFilesToAdd = sFilesToAdd + ":" + entryName;
                continue;
            }
            sFilesToAdd = sFilesToAdd + entryName;
        }
        if (sFilesToAdd.length() == 0) {
            hasContentFiles = false;
        }
        for (String entryName : classes.keySet()) {
            entryFile = (File)classes.get(entryName);
            if (entryName.endsWith(".class")) {
                this.log("adding web class '" + entryName + "'", 3);
                sClassesToAdd = !sClassesToAdd.equals("") ? sClassesToAdd + ":" + entryName : sClassesToAdd + entryName;
                InnerClassFilenameFilter flt = new InnerClassFilenameFilter(entryFile.getName());
                File entryDir = entryFile.getParentFile();
                String[] innerfiles = entryDir.list(flt);
                int n = innerfiles.length;
                for (int i = 0; i < n; ++i) {
                    int entryIndex = entryName.lastIndexOf(entryFile.getName()) - 1;
                    entryName = entryIndex < 0 ? innerfiles[i] : entryName.substring(0, entryIndex) + File.separatorChar + innerfiles[i];
                    entryFile = new File(this.config.srcDir, entryName);
                    this.log("adding innerclass file '" + entryName + "'", 3);
                    sClassesToAdd = sClassesToAdd + ":" + entryName;
                }
                continue;
            }
            if (entryName.endsWith(".jar")) {
                this.log("adding library JAR '" + entryName + "'", 3);
                if (!sJarFilesToAdd.equals("")) {
                    sJarFilesToAdd = sJarFilesToAdd + ":" + entryFile.toString();
                    continue;
                }
                sJarFilesToAdd = sJarFilesToAdd + entryFile.toString();
                continue;
            }
            this.log("adding non-class, non-jar file " + entryName, 2);
            if (sFilesToAdd.length() == 0) {
                sFilesToAdd = sFilesToAdd + entryName;
                continue;
            }
            sFilesToAdd = sFilesToAdd + ":" + entryName;
        }
        String args = "";
        args = "-webArchive ";
        if (sClassesToAdd != "") {
            args = args + " -classpath ";
            String CPATH = this.config.srcDir.getPath();
            args = args + CPATH + " ";
            args = args + "-classFiles ";
            args = args + sClassesToAdd + " ";
        }
        if (sJarFilesToAdd != "") {
            args = args + " -libraryJars ";
            args = args + sJarFilesToAdd + " ";
        }
        if (!hasContentFiles && sFilesToAdd.length() > 0) {
            this.config.contentDir = new File(TSBuildListener.tsHome, "classes");
        }
        if (this.config.contentDir != null) {
            this.log("config.contentDir is " + this.config.contentDir.getPath(), 3);
            if (sFilesToAdd != "") {
                args = args + this.config.contentDir.getPath() + " ";
                args = args + "-contentFiles ";
                args = args + sFilesToAdd + " ";
            } else {
                File reallyEmptyDir = new File(webEmpty, "really_empty");
                if (!reallyEmptyDir.exists()) {
                    if (!reallyEmptyDir.mkdirs()) {
                        this.log("WARNING:Failed to mkdirs. war will have unneeded files:" + reallyEmptyDir.getPath(), 1);
                    } else {
                        this.config.contentDir = reallyEmptyDir;
                    }
                } else {
                    this.config.contentDir = reallyEmptyDir;
                }
                args = args + this.config.contentDir.getPath() + " ";
            }
        } else {
            args = args + this.project.getProperty("ts.home") + "/dev ";
        }
        args = args + this.config.descriptorDir.getPath() + File.separator + this.descriptorXmlFileName + " ";
        args = args + jarfile.getPath();
        this.invokePackager(jarfile, args);
    }

    public void validateConfigured() throws BuildException {
        super.validateConfigured();
        this.checkContentDir();
    }

    private void checkContentDir() {
        boolean noContentDir;
        int n = this.config.contentFileSets.size();
        boolean bl = noContentDir = this.config.contentDir == null || !this.config.contentDir.isDirectory();
        if (n == 0 && noContentDir) {
            this.config.contentDir = webEmpty;
        } else if (n == 1 && noContentDir) {
            FileSet fs = (FileSet)this.config.contentFileSets.get(0);
            this.config.contentDir = fs.getDir(this.project);
        } else if (n > 1) {
            File tmpContent = new File(TSBuildListener.tsHome, "tmp/contentRoot");
            String excludes = "";
            if (tmpContent.exists()) {
                FileSet toDel = new FileSet();
                toDel.setDir(tmpContent);
                toDel.setDefaultexcludes(false);
                toDel.setIncludes("**/*");
                Delete del = new Delete();
                del.setProject(this.project);
                del.init();
                del.setTaskName("webwar");
                del.setIncludeEmptyDirs(true);
                del.addFileset(toDel);
                del.perform();
            } else if (!tmpContent.mkdirs()) {
                this.project.log("Cannot mkdir, web content will be incomplete:" + tmpContent.getPath(), 1);
            }
            Copy copy = new Copy();
            copy.setProject(this.project);
            copy.init();
            copy.setTaskName("webwar");
            copy.setTodir(tmpContent);
            int m = this.config.contentFileSets.size();
            for (int i = 0; i < m; ++i) {
                copy.addFileset((FileSet)this.config.contentFileSets.get(i));
            }
            copy.perform();
            this.config.contentDir = tmpContent;
            this.config.contentFileSets.clear();
            FileSet newfs = new FileSet();
            newfs.setDir(tmpContent);
            this.config.contentFileSets.add(newfs);
        }
    }
}

