/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.config.TSServerAuthConfig;
import com.sun.ts.tests.jaspic.tssv.util.TSFileHandler;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import com.sun.ts.tests.jaspic.tssv.util.TSXMLFormatter;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;

public class TSAuthConfigProviderStandalone
implements AuthConfigProvider {
    public static String DESC_KEY = "description_key";
    private static TSLogger logger;
    private HashMap serverAuthConfigMap = new HashMap();
    private static Map properties;
    private String description = null;

    public TSAuthConfigProviderStandalone(Map props, AuthConfigFactory factory) {
        this(props, null, factory, null);
        logger.log(Level.INFO, "invoked TSAuthConfigProviderStandalone() constructor(2 args)");
    }

    public TSAuthConfigProviderStandalone(Map props, TSLogger tsLogger, AuthConfigFactory factory) {
        this(props, tsLogger, factory, null);
        logger.log(Level.INFO, "invoked TSAuthConfigProviderStandalone() constructor(3 args)");
    }

    public TSAuthConfigProviderStandalone(Map props, TSLogger tsLogger, AuthConfigFactory factory, String description) {
        properties = props;
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, null, null, "TSAuthConfigProviderStandalone self registration");
        }
        if (tsLogger != null) {
            logger = tsLogger;
        } else {
            TSAuthConfigProviderStandalone.initializeTSLogger();
        }
        if (description != null) {
            this.description = description;
        } else {
            this.description = this.getDescFromProps(props);
            if (this.description == null) {
                this.description = "PERSIST_DEFAULT";
            }
        }
        logger.log(Level.INFO, "invoked TSAuthConfigProviderStandalone() constructor(4 args)");
    }

    private String getDescFromProps(Map props) {
        String strDesc = null;
        if (props != null) {
            strDesc = (String)props.get(DESC_KEY);
        }
        return strDesc;
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        logger.log(Level.INFO, "WARNING:  shouldnt get into ClientAuthConfig() for servlet profile");
        return null;
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        logger.log(Level.INFO, "TSAuthConfigProviderStandalone.getServerAuthConfig() called");
        String logStr = "TSAuthConfigProviderStandalone.getServerAuthConfig : layer=" + layer + " : appContext=" + appContext;
        logger.log(Level.INFO, logStr);
        try {
            String msg;
            if (handler == null) {
                msg = "FAILURE: layer=" + layer + " appContext=" + appContext;
                msg = msg + " getServerAuthConfig() received CallbackHandler=null";
                logger.log(Level.INFO, msg);
            } else {
                msg = "layer=" + layer + " appContext=" + appContext;
                msg = msg + " getServerAuthConfig() received CallbackHandler=non-null";
                logger.log(Level.INFO, msg);
            }
            TSServerAuthConfig serverAuthConfig = new TSServerAuthConfig(layer, appContext, handler, properties, logger);
            this.serverAuthConfigMap.put(layer + appContext, serverAuthConfig);
            return serverAuthConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthException(e.getMessage());
        }
    }

    public void refresh() {
    }

    private static void initializeTSLogger() {
        String logFileLocation = null;
        if (logger != null) {
            return;
        }
        try {
            logFileLocation = System.getProperty("log.file.location");
            if (logFileLocation == null) {
                throw new RuntimeException("log.file.location not set");
            }
            logger = TSLogger.getTSLogger("jsr196");
            boolean appendMode = true;
            TSFileHandler fileHandler = new TSFileHandler(logFileLocation + "/TSSVLog.txt", appendMode);
            fileHandler.setFormatter(new TSXMLFormatter());
            logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("TSLogger Initialization failed", e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String val) {
        this.description = val;
    }

    static {
        properties = null;
    }
}

