/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import com.sun.ts.tests.jaspic.tssv.config.TSRegistrationListener;
import com.sun.ts.tests.jaspic.tssv.util.AuthDataCallbackHandler;
import com.sun.ts.tests.jaspic.tssv.util.SimplePrincipal;
import com.sun.ts.tests.jaspic.tssv.util.TSSOAPMessageInfo;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class SimulateRuntime {
    public static void main(String[] args) {
        HashMap properties = new HashMap();
        String logFileLocation = args[0];
        String providerConfigurationFileLocation = args[1];
        try {
            System.setProperty("log.file.location", logFileLocation);
            System.setProperty("provider.configuration.file", providerConfigurationFileLocation);
            AuthConfigFactory acf = AuthConfigFactory.getFactory();
            TSRegistrationListener rlis = new TSRegistrationListener();
            AuthDataCallbackHandler cbh = new AuthDataCallbackHandler();
            AuthConfigProvider acp = acf.getConfigProvider("SOAP", "JSR196Context", (RegistrationListener)rlis);
            AuthConfigProvider acp2 = acf.getConfigProvider("SOAP", "JSR196Context-2", (RegistrationListener)rlis);
            ServerAuthConfig serverAuthConfig = acp2.getServerAuthConfig("SOAP", "JSR196Context", (CallbackHandler)cbh);
            MessageInfo msgInfo = SimulateRuntime.getSOAPMessageInfo();
            Subject defaultSubject = SimulateRuntime.getDefaultSubject();
            String operation = serverAuthConfig.getAuthContextID(msgInfo);
            ServerAuthContext serverAuthContext = serverAuthConfig.getAuthContext(operation, defaultSubject, properties);
            serverAuthContext.validateRequest(msgInfo, defaultSubject, defaultSubject);
            serverAuthContext.secureResponse(msgInfo, defaultSubject);
            ClientAuthConfig clientAuthConfig = acp2.getClientAuthConfig("SOAP", "JSR196Context", (CallbackHandler)cbh);
            operation = clientAuthConfig.getAuthContextID(msgInfo);
            ClientAuthContext clientAuthContext = clientAuthConfig.getAuthContext(operation, defaultSubject, properties);
            clientAuthContext.secureRequest(msgInfo, defaultSubject);
            clientAuthContext.validateResponse(msgInfo, defaultSubject, defaultSubject);
            AuthConfigProvider servletACP = acf.getConfigProvider("HttpServlet", "/spitests_servlet_web/ModTestServlet", (RegistrationListener)rlis);
            if (servletACP == null) {
                String err = "SimulateRuntime: servletACP == null!";
                System.out.println(err);
                throw new Exception(err);
            }
            ServerAuthConfig sac = servletACP.getServerAuthConfig("HttpServlet", "/spitests_servlet_web/ModTestServlet", (CallbackHandler)cbh);
            operation = SimulateRuntime.getServletProfileOperation();
            Subject subj = SimulateRuntime.getDefaultSubject();
            if (sac == null) {
                System.out.println("SimulateRuntime: sac == null!");
            } else {
                ServerAuthContext serverAuthContext2 = sac.getAuthContext(operation, subj, properties);
            }
            AuthConfigProvider authConfigProvider = acf.getConfigProvider("HttpServlet", "/spitests_servlet_web/SecondaryTestServlet", (RegistrationListener)rlis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Simulation Over, Created Log file :" + logFileLocation + "/TSSVLog.txt");
    }

    public static String getServletProfileOperation() {
        String servletPath = "/ModTestServlet";
        String method = "POST";
        return servletPath + "%20 " + method;
    }

    public static Subject getDefaultSubject() {
        Subject subject = new Subject();
        String username = "j2ee";
        String password = "j2ee";
        SimplePrincipal principal = new SimplePrincipal(username, password);
        subject.getPrincipals().add(principal);
        return subject;
    }

    private static MessageInfo getSOAPMessageInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jakarta.xml.ws.wsdl.service", "http://hostname.port/someuri");
        return new TSSOAPMessageInfo(map);
    }
}

