/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceProviderTest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceProviderTest.Hello;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceProviderTest.HelloService;
import jakarta.xml.ws.WebServiceRef;
import java.util.Properties;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    Hello port = null;
    @WebServiceRef(name="service/wsejbwebserviceprovidertest")
    static HelloService service;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)"Get wsejbwebserviceprovidertest Service via @WebServiceRef annotation");
        TestUtil.logMsg((String)"Uses name attribute @WebServiceRef(name=\"service/wsejbwebserviceprovidertest\")");
        TestUtil.logMsg((String)("service=" + service));
        TestUtil.logMsg((String)"Get port from service");
        this.port = service.getHelloPort();
        TestUtil.logMsg((String)("port=" + this.port));
        TestUtil.logMsg((String)"Port obtained");
        JAXWS_Util.dumpTargetEndpointAddress(this.port);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.getPort();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void WSEjbWebServiceProviderTestCallSayHello() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceProviderTestCallSayHello");
        boolean pass = true;
        for (int i = 0; i < 10; ++i) {
            String ret = this.port.sayHello("ProviderRef Tester loop#" + i + "!");
            if (ret.indexOf("WSEjbWebServiceProvider-SayHello") == -1) {
                TestUtil.logErr((String)("Unexpected greeting " + ret));
                pass = false;
                break;
            }
            TestUtil.logMsg((String)("Got expected greeting " + ret));
        }
        if (!pass) {
            throw new EETest.Fault("WSEjbWebServiceProviderTestCallSayHello failed");
        }
    }

    public void WSEjbWebServiceProviderTestVerifyTargetEndpointAddress() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceProviderTestVerifyTargetEndpointAddress");
        try {
            String endpointaddr = JAXWS_Util.getTargetEndpointAddress(this.port);
            TestUtil.logMsg((String)"Verify that the target endpoint address ends with [WSEjbWebServiceProviderTest/ejb]");
            if (!endpointaddr.endsWith("WSEjbWebServiceProviderTest/ejb")) {
                throw new RuntimeException("Target Endpoint Address is incorrect: " + endpointaddr);
            }
            TestUtil.logMsg((String)"WSEjbWebServiceProviderTestVerifyTargetEndpointAddress passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceProviderTestVerifyTargetEndpointAddress failed");
        }
    }
}

