/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.variants.CompoundPK;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.CompoundBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.CompoundBeanHome;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.FloatBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.FloatBeanHome;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.LongBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.LongBeanHome;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.StringBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey.StringBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String pref = "java:comp/env/ejb/";
    private static final String stringLookup = "java:comp/env/ejb/StringBean";
    private static final String longLookup = "java:comp/env/ejb/LongBean";
    private static final String floatLookup = "java:comp/env/ejb/FloatBean";
    private static final String compoundLookup = "java:comp/env/ejb/CompoundBean";
    private TSNamingContext ctx = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            this.props = props;
            this.logTrace("Getting naming context...");
            this.ctx = new TSNamingContext();
            this.logMsg("Client: Initializing DB tables...");
            DAOFactory.getInstance().getStringPKCoffeeDAO().cleanup();
            DAOFactory.getInstance().getLongPKCoffeeDAO().cleanup();
            DAOFactory.getInstance().getFloatPKCoffeeDAO().cleanup();
            DAOFactory.getInstance().getCompoundPKCoffeeDAO().cleanup();
            this.logMsg("Client: Setup OK!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testStringPK() throws EETest.Fault {
        String refPK1 = "cof001";
        String refPK2 = "cof007";
        StringBeanHome home = null;
        StringBean bean1 = null;
        StringBean bean2 = null;
        boolean pass = true;
        try {
            this.logTrace("Looking up home...");
            home = (StringBeanHome)this.ctx.lookup(stringLookup, StringBeanHome.class);
            this.logTrace("Client: Creating bean1 and bean2 instance...");
            bean1 = home.create(this.props, "cof001", "Arabica", 10.0f);
            bean2 = home.create(this.props, "cof007", "Java", 12.0f);
            this.logTrace("Client: Locate beans using primary keys...");
            StringBean bean3 = home.findByPrimaryKey("cof001");
            StringBean bean4 = home.findByPrimaryKey("cof007");
            this.logMsg("Client: Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            this.logMsg("Client: Check beans are identical...");
            boolean bl = pass = bean1.isIdentical(bean3) && bean3.isIdentical(bean1);
            if (!pass) {
                throw new Exception("bean1 and bean3 should be identical!");
            }
            boolean bl2 = pass = bean2.isIdentical(bean4) && bean4.isIdentical(bean2);
            if (!pass) {
                throw new Exception("bean2 and bean4 should be identical!");
            }
            this.logMsg("Client: Comparing primary keys...");
            String valPK1 = (String)bean3.getPrimaryKey();
            String valPK2 = (String)bean4.getPrimaryKey();
            boolean bl3 = pass = valPK1.equals("cof001") && "cof001".equals(valPK1);
            if (!pass) {
                throw new Exception("bean1 and bean3 PK should match!");
            }
            boolean bl4 = pass = valPK2.equals("cof007") && "cof007".equals(valPK2);
            if (!pass) {
                throw new Exception("bean2 and bean4 PK should match!");
            }
            this.logMsg("Client: Remove the beans...");
            home.remove("cof001");
            bean1 = null;
            home.remove("cof007");
            bean2 = null;
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: " + e);
            throw new EETest.Fault("String PKEY test failed: " + e, e);
        }
        finally {
            try {
                if (null != bean1) {
                    home.remove("cof001");
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean remove" + e);
            }
            try {
                if (null != bean2) {
                    home.remove("cof007");
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean2 remove" + e);
            }
        }
    }

    public void testLongPK() throws EETest.Fault {
        Long refPK1 = new Long(1515L);
        Long refPK2 = new Long(1789L);
        LongBeanHome home = null;
        LongBean bean1 = null;
        LongBean bean2 = null;
        boolean pass = true;
        try {
            this.logTrace("Looking up home...");
            home = (LongBeanHome)this.ctx.lookup(longLookup, LongBeanHome.class);
            this.logTrace("Client: Creating bean1 and bean2 instance...");
            bean1 = home.create(this.props, refPK1, "Arabica", 10.0f);
            bean2 = home.create(this.props, refPK2, "Java", 12.0f);
            this.logTrace("Client: Locate beans using primary keys...");
            LongBean bean3 = home.findByPrimaryKey(refPK1);
            LongBean bean4 = home.findByPrimaryKey(refPK2);
            this.logMsg("Client: Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            this.logMsg("Client: Check beans are identical...");
            boolean bl = pass = bean1.isIdentical(bean3) && bean3.isIdentical(bean1);
            if (!pass) {
                throw new Exception("bean1 and bean3 should be identical!");
            }
            boolean bl2 = pass = bean2.isIdentical(bean4) && bean4.isIdentical(bean2);
            if (!pass) {
                throw new Exception("bean2 and bean4 should be identical!");
            }
            this.logMsg("Client: Comparing primary keys...");
            Long valPK1 = (Long)bean3.getPrimaryKey();
            Long valPK2 = (Long)bean4.getPrimaryKey();
            boolean bl3 = pass = valPK1.equals(refPK1) && refPK1.equals(valPK1);
            if (!pass) {
                throw new Exception("bean1 and bean3 PK should match!");
            }
            boolean bl4 = pass = valPK2.equals(refPK2) && refPK2.equals(valPK2);
            if (!pass) {
                throw new Exception("bean2 and bean4 PK should match!");
            }
            this.logMsg("Client: Remove the beans...");
            home.remove(refPK1);
            bean1 = null;
            home.remove(refPK2);
            bean2 = null;
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: " + e);
            throw new EETest.Fault("Long PKEY test failed: " + e, e);
        }
        finally {
            try {
                if (null != bean1) {
                    home.remove(refPK1);
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean remove" + e);
            }
            try {
                if (null != bean2) {
                    home.remove(refPK2);
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean2 remove" + e);
            }
        }
    }

    public void testFloatPK() throws EETest.Fault {
        Float refPK1 = new Float(37.2);
        Float refPK2 = new Float(9.5);
        FloatBeanHome home = null;
        FloatBean bean1 = null;
        FloatBean bean2 = null;
        boolean pass = true;
        try {
            this.logTrace("Looking up home...");
            home = (FloatBeanHome)this.ctx.lookup(floatLookup, FloatBeanHome.class);
            this.logTrace("Client: Creating bean1 and bean2 instance...");
            bean1 = home.create(this.props, refPK1.floatValue(), "Arabica", 10.0f);
            bean2 = home.create(this.props, refPK2.floatValue(), "Java", 12.0f);
            this.logTrace("Client: Locate beans using primary keys...");
            FloatBean bean3 = home.findByPrimaryKey(refPK1);
            FloatBean bean4 = home.findByPrimaryKey(refPK2);
            this.logMsg("Client: Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            this.logMsg("Client: Check beans are identical...");
            boolean bl = pass = bean1.isIdentical(bean3) && bean3.isIdentical(bean1);
            if (!pass) {
                throw new Exception("bean1 and bean3 should be identical!");
            }
            boolean bl2 = pass = bean2.isIdentical(bean4) && bean4.isIdentical(bean2);
            if (!pass) {
                throw new Exception("bean2 and bean4 should be identical!");
            }
            this.logMsg("Client: Comparing primary keys...");
            Float valPK1 = (Float)bean3.getPrimaryKey();
            Float valPK2 = (Float)bean4.getPrimaryKey();
            boolean bl3 = pass = valPK1.equals(refPK1) && refPK1.equals(valPK1);
            if (!pass) {
                throw new Exception("bean1 and bean3 PK should match!");
            }
            boolean bl4 = pass = valPK2.equals(refPK2) && refPK2.equals(valPK2);
            if (!pass) {
                throw new Exception("bean2 and bean4 PK should match!");
            }
            this.logMsg("Client: Remove the beans...");
            home.remove(refPK1);
            bean1 = null;
            home.remove(refPK2);
            bean2 = null;
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: " + e);
            throw new EETest.Fault("Float PKEY test failed: " + e, e);
        }
        finally {
            try {
                if (null != bean1) {
                    home.remove(refPK1);
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean remove" + e);
            }
            try {
                if (null != bean2) {
                    home.remove(refPK2);
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean2 remove" + e);
            }
        }
    }

    public void testCompoundPK() throws EETest.Fault {
        CompoundPK refPK1 = new CompoundPK(1, "cof0001", 37.2f);
        CompoundPK refPK2 = new CompoundPK(1, "cof0001", 7.5f);
        CompoundBeanHome home = null;
        CompoundBean bean1 = null;
        CompoundBean bean2 = null;
        boolean pass = true;
        try {
            this.logTrace("Looking up home...");
            home = (CompoundBeanHome)this.ctx.lookup(compoundLookup, CompoundBeanHome.class);
            this.logTrace("Client: Creating bean1 and bean2 instance...");
            bean1 = home.create(this.props, refPK1, "Arabica", 10.0f);
            bean2 = home.create(this.props, refPK2, "Java", 12.0f);
            this.logTrace("Client: Locate beans using primary keys...");
            CompoundBean bean3 = home.findByPrimaryKey(refPK1);
            CompoundBean bean4 = home.findByPrimaryKey(refPK2);
            this.logMsg("Client: Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            this.logMsg("Client: Check beans are identical...");
            boolean bl = pass = bean1.isIdentical(bean3) && bean3.isIdentical(bean1);
            if (!pass) {
                throw new Exception("bean1 and bean3 should be identical!");
            }
            boolean bl2 = pass = bean2.isIdentical(bean4) && bean4.isIdentical(bean2);
            if (!pass) {
                throw new Exception("bean2 and bean4 should be identical!");
            }
            this.logMsg("Client: Comparing primary keys...");
            CompoundPK valPK1 = (CompoundPK)bean3.getPrimaryKey();
            CompoundPK valPK2 = (CompoundPK)bean4.getPrimaryKey();
            boolean bl3 = pass = valPK1.equals(refPK1) && refPK1.equals(valPK1);
            if (!pass) {
                throw new Exception("bean1 and bean3 PK should match!");
            }
            boolean bl4 = pass = valPK2.equals(refPK2) && refPK2.equals(valPK2);
            if (!pass) {
                throw new Exception("bean2 and bean4 PK should match!");
            }
            this.logMsg("Client: Remove the beans...");
            home.remove(refPK1);
            bean1 = null;
            home.remove(refPK2);
            bean2 = null;
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: " + e);
            throw new EETest.Fault("Compound PKEY test failed: " + e, e);
        }
        finally {
            try {
                if (null != bean1) {
                    home.remove(refPK1);
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean remove" + e);
            }
            try {
                if (null != bean2) {
                    home.remove(refPK2);
                }
            }
            catch (Exception e) {
                this.logTrace("Client: Ignoring exception on bean2 remove" + e);
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("Client: cleanup");
    }
}

