/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.wsa.common.WsaSOAPUtils;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest.Echo;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest.EchoService;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest.EjbClientIF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateful;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.RespectBinding;
import jakarta.xml.ws.WebServiceRef;
import jakarta.xml.ws.soap.Addressing;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.util.Map;
import java.util.Properties;

@Stateful(name="WSEjbWSRefRespBindAndAddressingCombinedTestClntBean")
@Remote(value={EjbClientIF.class})
public class EjbClient
implements EjbClientIF {
    private Properties harnessProps = null;
    private static final boolean debug = false;
    @Addressing
    @RespectBinding(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestport1", type=Echo.class, value=EchoService.class)
    Echo port1 = null;
    @Addressing(enabled=true, required=true)
    @RespectBinding(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestport2", type=Echo.class, value=EchoService.class)
    Echo port2 = null;
    @Addressing(enabled=false)
    @RespectBinding(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestport3", type=Echo.class, value=EchoService.class)
    Echo port3 = null;
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestservice")
    EchoService service = null;

    @PostConstruct
    public void postConstruct() {
        System.out.println("EjbClient:postConstruct()");
        System.out.println("EjbClient DEBUG: service=" + this.service);
        System.out.println("EjbClient DEBUG: port1=" + this.port1);
        System.out.println("EjbClient DEBUG: port2=" + this.port2);
        System.out.println("EjbClient DEBUG: port3=" + this.port3);
        if (this.service == null || this.port2 == null || this.port1 == null || this.port3 == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        this.harnessProps = p;
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean echo(String string, String testName) {
        if (testName.equals("VerifyAddrHeadersExistForEnabledRequiredPort")) {
            return this.VerifyAddrHeadersExistForEnabledRequiredPort();
        }
        return this.VerifyFaultConditionOnPort();
    }

    private String getTargetEndpointAddress(Object stub) throws Exception {
        BindingProvider bindingprovider = (BindingProvider)stub;
        Map context = bindingprovider.getRequestContext();
        String url = (String)context.get("jakarta.xml.ws.service.endpoint.address");
        return url;
    }

    private boolean VerifyAddrHeadersExistForEnabledRequiredPort() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST be present on the SOAPRequest");
            TestUtil.logMsg((String)"VerifyAddrHeadersExistForEnabledRequiredPort");
            Holder testName = new Holder((Object)"VerifyAddrHeadersExistForEnabledRequiredPort");
            this.port2.echo("Echo from EjbClient on port2", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean VerifyFaultConditionOnPort() {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"VerifyFaultConditionOnPort");
            Holder testName = new Holder((Object)"VerifyFaultConditionOnPort");
            this.port3.echo("Echo from EjbClient on port3", (Holder<String>)testName);
            TestUtil.logErr((String)"SOAPFaultException was not thrown back");
            pass = false;
        }
        catch (SOAPFaultException sfe) {
            TestUtil.logMsg((String)("Caught expected SOAPFaultException: " + sfe.getMessage()));
            try {
                TestUtil.logMsg((String)("FaultCode=" + WsaSOAPUtils.getFaultCode(sfe)));
                TestUtil.logMsg((String)("FaultString=" + WsaSOAPUtils.getFaultString(sfe)));
                if (WsaSOAPUtils.isMessageAddressingHeaderRequiredFaultCode(sfe)) {
                    TestUtil.logMsg((String)"SOAPFault contains expected faultcode MessageAddressingHeaderRequired");
                } else {
                    String faultcode = WsaSOAPUtils.getFaultCode(sfe);
                    TestUtil.logErr((String)("SOAPFault contains unexpected faultcode got: " + faultcode + ", expected: MessageAddressingHeaderRequired"));
                    pass = false;
                }
                if (WsaSOAPUtils.getFaultString(sfe) == null) {
                    TestUtil.logErr((String)"The faultstring element MUST EXIST for SOAP 1.1 Faults");
                    pass = false;
                }
                if (WsaSOAPUtils.getFaultDetail(sfe) != null) {
                    TestUtil.logErr((String)"The faultdetail element MUST NOT EXIST for SOAP 1.1 Faults related to header entries");
                    pass = false;
                }
            }
            catch (Exception e2) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e2.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

