/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.interceptor;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeIF;
import com.sun.ts.tests.ejb30.common.interceptor.Constants;
import jakarta.ejb.EJBException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;

public abstract class ClientBase
extends EETest
implements Constants {
    protected Properties props;

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
    }

    public void cleanup() throws EETest.Fault {
    }

    protected void remove() {
        if (this.getBean() != null) {
            try {
                this.getBean().remove();
                TLogger.log((String[])new String[]{"bean removed successfully."});
            }
            catch (Exception e) {
                TLogger.log((String[])new String[]{"failed to remove bean."});
            }
        }
    }

    public void getBeanTest() throws EETest.Fault {
        try {
            this.getBean().getBeanTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void getParametersTest() throws EETest.Fault {
        String expected = "old param value";
        String result = null;
        try {
            result = this.getBean().getParametersTest("old param value");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
        if (!expected.equals(result)) {
            throw new EETest.Fault("Expected " + expected + ", actual " + result);
        }
    }

    public void getParametersEmptyTest() throws EETest.Fault {
        try {
            this.getBean().getParametersEmptyTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void setParametersTest() throws EETest.Fault {
        String expected = "new param value";
        String result = null;
        try {
            result = this.getBean().setParametersTest("old param value");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
        if (!expected.equals(result)) {
            throw new EETest.Fault("Expected " + expected + ", actual " + result);
        }
    }

    public void getContextDataTest() throws EETest.Fault {
        try {
            this.getBean().getContextDataTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void getMethodTest() throws EETest.Fault {
        try {
            this.getBean().getMethodTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void txRollbackOnlyTest() throws EETest.Fault {
        try {
            this.getBean().txRollbackOnlyTest();
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("tx not rolled back properly.", e);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unexpected exception", e);
        }
    }

    public void txRollbackOnlyAfterTest() throws EETest.Fault {
        try {
            this.getBean().txRollbackOnlyAfterTest();
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("tx not rolled back properly.", e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sameSecContextTest() throws EETest.Fault {
        boolean expected = true;
        boolean result = false;
        try {
            result = this.getBean().sameSecContextTest();
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("Test failed:", e);
        }
        catch (Exception e) {
            throw new EETest.Fault("Test failed:", e);
        }
        if (result != expected) {
            throw new EETest.Fault("Expected " + expected + ", actual=" + result + ".");
        }
    }

    public void exceptionTest() throws EETest.Fault {
        String expected = null;
        String result = null;
        try {
            result = this.getBean().exceptionTest();
        }
        catch (CalculatorException e) {
            TLogger.log((String[])new String[]{"got expected exceptioin."});
        }
        catch (Exception e) {
            throw new EETest.Fault("Expected a CalculatorException, actual ", e);
        }
        if (result != null) {
            throw new EETest.Fault("Expected " + expected + ", actual=" + result + ".");
        }
    }

    public void suppressExceptionTest() throws EETest.Fault {
        try {
            this.getBean().suppressExceptionTest();
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("This exception should have been supressed by interceptor.", e);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unexpected exception", e);
        }
    }

    public void runtimeExceptionTest() throws EETest.Fault {
        try {
            this.getBean().runtimeExceptionTest();
            throw new EETest.Fault("Should not get here. RuntimeException should've been thrown from AroundInvoke method.");
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("tx not rolled back properly.", e);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                TLogger.log((String[])new String[]{"Got RemoteException, OK."});
            } else if (e instanceof EJBException) {
                TLogger.log((String[])new String[]{"Got EJBException, OK."});
            } else {
                if (e instanceof RuntimeException) {
                    throw new EETest.Fault("Got RuntimeException. It should not be thrown to the client.");
                }
                throw new EETest.Fault("Unexpected exception: " + e.getClass(), e);
            }
            return;
        }
    }

    public void runtimeExceptionAfterTest() throws EETest.Fault {
        try {
            this.getBean().runtimeExceptionAfterTest();
            throw new EETest.Fault("Should not get here. RuntimeException should've been thrown from AroundInvoke method.");
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("tx not rolled back properly.", e);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                TLogger.log((String[])new String[]{"Got RemoteException, OK."});
            } else if (e instanceof EJBException) {
                TLogger.log((String[])new String[]{"Got EJBException, OK."});
            } else {
                if (e instanceof RuntimeException) {
                    throw new EETest.Fault("Got RuntimeException. It should not be thrown to the client.");
                }
                throw new EETest.Fault("Unexpected exception: " + e.getClass(), e);
            }
            return;
        }
    }

    public void orderTest() throws EETest.Fault {
        try {
            this.getBean().orderTest();
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("Test failed.", e);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unexpected exception", e);
        }
    }

    public void sameInvocationContextTest() throws EETest.Fault {
        try {
            this.getBean().sameInvocationContextTest();
        }
        catch (CalculatorException e) {
            throw new EETest.Fault("Test failed.", e);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unexpected exception", e);
        }
    }

    public void methodLevelInterceptorMixedTest() throws CalculatorException {
        String firstMethodInterceptor = "InterceptorNoat1";
        String secondMethodInterceptor = "Interceptor1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList result = this.getBean().methodLevelInterceptorMixedTest(new ArrayList());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + expected + ", actual " + result);
        }
        TLogger.log((String[])new String[]{"Method-level interceptors are invoked in the correct order: " + result});
    }

    public void methodLevelClassLevelInterceptorMixedTest() throws CalculatorException {
        String firstMethodInterceptor = "Interceptor1";
        String secondMethodInterceptor = "InterceptorNoat1";
        String firstClassInterceptor = "Interceptor1";
        String secondClassInterceptor = "InterceptorNoat1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstClassInterceptor);
        expected.add(firstClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList result = this.getBean().methodLevelClassLevelInterceptorMixedTest(new ArrayList());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + expected + ", actual " + result);
        }
        TLogger.log((String[])new String[]{"Method-level interceptors are invoked in the correct order: " + result});
    }

    public void repeatedInterceptors() throws CalculatorException {
        String firstMethodInterceptor = "InterceptorNoat1";
        String secondMethodInterceptor = "Interceptor1";
        String firstClassInterceptor = "Interceptor1";
        String secondClassInterceptor = "InterceptorNoat1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstClassInterceptor);
        expected.add(firstClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList result = this.getBean().repeatedInterceptors(new ArrayList());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + expected + ", actual " + result);
        }
        TLogger.log((String[])new String[]{"Method-level interceptors are invoked in the correct order: " + result});
    }

    public void interceptorOrderingOverride() throws CalculatorException {
        String firstMethodInterceptor = "InterceptorNoat1";
        String secondMethodInterceptor = "Interceptor1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList result = this.getBean().interceptorOrderingOverride(new ArrayList());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + expected + ", actual " + result);
        }
        TLogger.log((String[])new String[]{"Method-level interceptors are invoked in the correct order: " + result});
    }

    public void afterBeginTest() throws EETest.Fault {
        try {
            this.getBean().afterBeginTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void beforeCompletionTest() throws EETest.Fault {
        try {
            this.getBean().beforeCompletionTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    protected abstract AroundInvokeIF getBean();
}

