/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.dao.coffee;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DataSourceDAO;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import jakarta.ejb.CreateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class DataSourceCoffeeDAO
extends DataSourceDAO
implements CoffeeDAO {
    public static final String DEFAULT_TABLE_PREFIX = "COFFEE";
    protected static final String SQL_EXISTS = "select";
    protected static final String SQL_CREATE = "insert";
    protected static final String SQL_LOAD = "select";
    protected static final String SQL_LOAD_PRICE = "select_price";
    protected static final String SQL_STORE = "update";
    protected static final String SQL_STORE_PRICE = "update_price";
    protected static final String SQL_DELETE = "delete";
    protected static final String SQL_DELETE_ALL = "delete_all";

    public DataSourceCoffeeDAO(String sqlTablePrefix) throws DAOException {
        super(sqlTablePrefix);
    }

    public DataSourceCoffeeDAO(String sqlTablePrefix, String user, String password) throws DAOException {
        super(sqlTablePrefix, user, password);
    }

    @Override
    public boolean exists(int pkey) throws DAOException {
        boolean bl;
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)("[DataSourceCoffeeDAO] exists(" + pkey + ")"));
            pStmt = this.getStmt("select");
            pStmt.setInt(1, pkey);
            result = pStmt.executeQuery();
            bl = result.next();
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in keyExists: ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, result);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, result);
        return bl;
    }

    @Override
    public void create(CoffeeBean bean) throws CreateException, DAOException {
        this.create(bean.getId(), bean.getName(), bean.getPrice());
    }

    @Override
    public void create(int id, String name, float price) throws CreateException, DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)("[DataSourceCoffeeDAO] create {" + id + ", " + name + ", " + price + "}"));
            pStmt = this.getStmt(SQL_CREATE);
            pStmt.setInt(1, id);
            pStmt.setString(2, name);
            pStmt.setFloat(3, price);
            TestUtil.logTrace((String)("[DataSourceCoffeeDAO] Execute stmt" + pStmt));
            if (1 != pStmt.executeUpdate()) {
                throw new CreateException("DB INSERT failed");
            }
        }
        catch (SQLException e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new DAOException("SQLException in createNewRow", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, null);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, null);
        TestUtil.logTrace((String)"[DataSourceCoffeeDAO] New row created !");
    }

    @Override
    public CoffeeBean load(int id) throws DAOException {
        CoffeeBean bean;
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)("[DataSourceCoffeeDAO] load(" + id + ")"));
            pStmt = this.getStmt("select");
            pStmt.setInt(1, id);
            result = pStmt.executeQuery();
            if (!result.next()) {
                throw new SQLException("No record for PK = " + id);
            }
            String name = result.getString(1);
            float price = result.getFloat(2);
            bean = new CoffeeBean(id, name, price);
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in load(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, result);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, result);
        return bean;
    }

    @Override
    public float loadPrice(int id) throws DAOException {
        float f;
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)("[DataSourceCoffeeDAO] loadPrice(" + id + ")"));
            pStmt = this.getStmt(SQL_LOAD_PRICE);
            pStmt.setInt(1, id);
            result = pStmt.executeQuery();
            if (!result.next()) {
                throw new SQLException("No record for PK = " + id);
            }
            f = result.getFloat(1);
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in loadPrice(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, result);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, result);
        return f;
    }

    @Override
    public void store(CoffeeBean bean) throws DAOException {
        PreparedStatement pStmt = null;
        if (null == bean) {
            throw new IllegalArgumentException("Null bean");
        }
        try {
            TestUtil.logTrace((String)("[DataSourceCoffeeDAO] store {id=" + bean.getId() + ", name=" + bean.getName() + ", price=" + bean.getPrice() + "}"));
            pStmt = this.getStmt(SQL_STORE);
            pStmt.setString(1, bean.getName());
            pStmt.setFloat(2, bean.getPrice());
            pStmt.setInt(3, bean.getId());
            if (1 != pStmt.executeUpdate()) {
                throw new SQLException("UPDATE failed in storePrice");
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in store(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, null);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, null);
    }

    @Override
    public void storePrice(int id, float price) throws DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)("[DataSourceCoffeeDAO] storePrice {id=" + id + ", price=" + price + "}"));
            pStmt = this.getStmt(SQL_STORE_PRICE);
            pStmt.setFloat(1, price);
            pStmt.setInt(2, id);
            if (1 != pStmt.executeUpdate()) {
                throw new SQLException("UPDATE failed in storePrice");
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in storePrice(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, null);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, null);
    }

    @Override
    public void delete(int id) throws DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)"[DataSourceCoffeeDAO] delete()");
            pStmt = this.getStmt(SQL_DELETE);
            pStmt.setInt(1, id);
            if (1 != pStmt.executeUpdate()) {
                throw new SQLException("DELETE failed in remove()");
            }
        }
        catch (SQLException e) {
            throw new DAOException("SQLException in remove(): ", e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }

    @Override
    public Collection nameToKeyCollection(String name) throws DAOException {
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)"[DataSourceCoffeeDAO] nameToKey");
            pStmt = this.getStmt("select_pk_by_name");
            pStmt.setString(1, name);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new DAOException("SQLException in nameToKey: ", e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }

    @Override
    public Collection priceToKeyCollection(float price) throws DAOException {
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)"priceToKey");
            pStmt = this.getStmt("select_pk_by_price");
            pStmt.setFloat(1, price);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new DAOException("SQL Exception in priceToKey", e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }

    @Override
    public Collection priceRangeToCollection(float min, float max) throws DAOException {
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)"priceRangeToCollection");
            pStmt = this.getStmt("select_pk_by_price_range");
            pStmt.setFloat(1, min);
            pStmt.setFloat(2, max);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new DAOException("SQL Exception in priceRangeToCollection", e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }

    @Override
    public Collection primaryKeyRangeToCollection(Integer min, Integer max) throws DAOException {
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)"primaryKeyRangeToCollection");
            pStmt = this.getStmt("select_pk_by_pk_range");
            pStmt.setInt(1, min);
            pStmt.setInt(2, max);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new DAOException("SQL Exception in primaryKeyRangeToCollection: ", e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }
}

