/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonwriterfactorytests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonWriterFactoryTest1() {
        boolean pass = true;
        JsonWriter writer1 = null;
        JsonWriter writer2 = null;
        String expString = "{}";
        JsonObject jsonObject = Json.createReader((Reader)new StringReader(expString)).readObject();
        try {
            LOGGER.info("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("--------------------------------------------------");
            LOGGER.info("TEST CASE [JsonWriterFactory.createWriter(Writer)]");
            LOGGER.info("--------------------------------------------------");
            LOGGER.info("Create 1st JsonWriter using JsonWriterFactory");
            StringWriter sWriter1 = new StringWriter();
            writer1 = writerFactory.createWriter((Writer)sWriter1);
            if (writer1 == null) {
                LOGGER.warning("WriterFactory failed to create writer1");
                pass = false;
            } else {
                writer1.writeObject(jsonObject);
                writer1.close();
            }
            LOGGER.info("sWriter1=" + ((Object)sWriter1).toString());
            String actString = JSONP_Util.removeWhitespace((String)((Object)sWriter1).toString());
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Create 2nd JsonWriter using JsonWriterFactory");
            StringWriter sWriter2 = new StringWriter();
            writer2 = writerFactory.createWriter((Writer)sWriter2);
            if (writer2 == null) {
                LOGGER.warning("WriterFactory failed to create writer2");
                pass = false;
            } else {
                writer2.writeObject(jsonObject);
                writer2.close();
            }
            LOGGER.info("sWriter2=" + ((Object)sWriter2).toString());
            actString = JSONP_Util.removeWhitespace((String)((Object)sWriter2).toString());
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterFactoryTest1 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonWriterFactoryTest1 Failed");
    }

    @Test
    public void jsonWriterFactoryTest2() {
        boolean pass = true;
        JsonWriter writer1 = null;
        JsonWriter writer2 = null;
        String expString = "{}";
        JsonObject jsonObject = Json.createReader((Reader)new StringReader(expString)).readObject();
        try {
            LOGGER.info("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-----------------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonWriterFactory.createWriter(OutputStream, Charset)]");
            LOGGER.info("-----------------------------------------------------------------");
            LOGGER.info("Create 1st JsonWriter using JsonWriterFactory with UTF-8 encoding");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            writer1 = writerFactory.createWriter((OutputStream)baos1, JSONP_Util.UTF_8);
            if (writer1 == null) {
                LOGGER.warning("WriterFactory failed to create writer1");
                pass = false;
            } else {
                writer1.writeObject(jsonObject);
                writer1.close();
            }
            LOGGER.info("baos1=" + baos1.toString("UTF-8"));
            String actString = JSONP_Util.removeWhitespace((String)baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Create 2nd JsonWriter using JsonWriterFactory with UTF-8 encoding");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            writer2 = writerFactory.createWriter((OutputStream)baos2, JSONP_Util.UTF_8);
            if (writer2 == null) {
                LOGGER.warning("WriterFactory failed to create writer2");
                pass = false;
            } else {
                writer2.writeObject(jsonObject);
                writer2.close();
            }
            LOGGER.info("baos2=" + baos2.toString("UTF-8"));
            actString = JSONP_Util.removeWhitespace((String)baos2.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterFactoryTest2 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonWriterFactoryTest2 Failed");
    }

    @Test
    public void jsonWriterFactoryTest3() {
        boolean pass = true;
        JsonWriter writer1 = null;
        JsonWriter writer2 = null;
        String expString = "{}";
        JsonObject jsonObject = Json.createReader((Reader)new StringReader(expString)).readObject();
        try {
            LOGGER.info("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("--------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonWriterFactory.createWriter(OutputStream)]");
            LOGGER.info("--------------------------------------------------------");
            LOGGER.info("Create 1st JsonWriter using JsonWriterFactory");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            writer1 = writerFactory.createWriter((OutputStream)baos1);
            if (writer1 == null) {
                LOGGER.warning("WriterFactory failed to create writer1");
                pass = false;
            } else {
                writer1.writeObject(jsonObject);
                writer1.close();
            }
            LOGGER.info("baos1=" + baos1.toString("UTF-8"));
            String actString = JSONP_Util.removeWhitespace((String)baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Create 2nd JsonWriter using JsonWriterFactory");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            writer2 = writerFactory.createWriter((OutputStream)baos2);
            if (writer2 == null) {
                LOGGER.warning("WriterFactory failed to create writer2");
                pass = false;
            } else {
                writer2.writeObject(jsonObject);
                writer2.close();
            }
            LOGGER.info("baos2=" + baos2.toString("UTF-8"));
            actString = JSONP_Util.removeWhitespace((String)baos2.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterFactoryTest3 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonWriterFactoryTest3 Failed");
    }

    @Test
    public void jsonWriterFactoryTest4() {
        boolean pass = true;
        try {
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Test scenario1: no supported provider property");
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig());
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-------------------------------------------");
            LOGGER.info("Test scenario2: supported provider property");
            LOGGER.info("-------------------------------------------");
            LOGGER.info("Create JsonWriterFactory with Map<String, ?> with FOO config");
            writerFactory = Json.createWriterFactory((Map)JSONP_Util.getFooConfig());
            config = writerFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-------------------------------------------------------------");
            LOGGER.info("Test scenario3: supported and non supported provider property");
            LOGGER.info("-------------------------------------------------------------");
            LOGGER.info("Create JsonGeneratorFactory with Map<String, ?> with all config");
            writerFactory = Json.createWriterFactory((Map)JSONP_Util.getAllConfig());
            config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)1, (String[])props)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterFactoryTest4 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonWriterFactoryTest4 Failed");
    }
}

