/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class WrapWriter
extends Writer {
    private Writer out;
    private int leftMargin = 0;
    private int rightMargin = Integer.getInteger("javatest.console.width", 80);
    private StringBuffer pending = new StringBuffer();
    private int charsOnLineSoFar = 0;
    private String lineSeparator = System.getProperty("line.separator", "\n");

    public WrapWriter(OutputStream out) {
        this.out = new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    public WrapWriter(Writer out) {
        this.out = out;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int m) {
        if (m < 0 || m >= this.rightMargin) {
            throw new IllegalArgumentException();
        }
        this.leftMargin = m;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int m) {
        if (m <= this.leftMargin) {
            throw new IllegalArgumentException();
        }
        this.rightMargin = m;
    }

    public int getCharsOnLineSoFar() {
        return this.charsOnLineSoFar;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.write(' ');
        this.out.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(cbuf[i]);
        }
    }

    public void write(char c) throws IOException {
        if (Character.isWhitespace(c)) {
            if (this.pending.length() > 0) {
                if (Math.max(this.leftMargin, this.charsOnLineSoFar + 1) + this.pending.length() > this.rightMargin) {
                    this.newLine();
                }
                if (this.charsOnLineSoFar < this.leftMargin) {
                    for (int i = this.charsOnLineSoFar; i < this.leftMargin; ++i) {
                        this.out.write(32);
                    }
                    this.charsOnLineSoFar = this.leftMargin;
                } else if (this.charsOnLineSoFar > this.leftMargin) {
                    this.out.write(32);
                    ++this.charsOnLineSoFar;
                }
                this.out.write(this.pending.toString());
                this.charsOnLineSoFar += this.pending.length();
                this.pending.setLength(0);
            }
            if (c == '\n') {
                this.newLine();
            } else if (c == '\t') {
                this.out.write(32);
                ++this.charsOnLineSoFar;
                while (this.charsOnLineSoFar % 8 != 0) {
                    this.out.write(32);
                    ++this.charsOnLineSoFar;
                }
            }
        } else {
            this.pending.append(c);
        }
    }

    private void newLine() throws IOException {
        this.out.write(this.lineSeparator);
        this.charsOnLineSoFar = 0;
    }
}

